return function(scale)
	return {
		Color = {
			ActionAlert = {
				Background = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(217, 28, 21),
					Transparency = 0,
				},
			},
			ActionEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionLink = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionOverMedia = {
				Background = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionSoftEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0.7,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(0, 20, 92),
					Transparency = 0,
				},
			},
			ActionStandard = {
				Background = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionSubEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionSubtle = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(73, 77, 90),
					Transparency = 0,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionUtility = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			Common = {
				Backdrop = {
					Color3 = Color3.fromRGB(10, 10, 14),
					Transparency = 0.5,
				},
				HeavyDivider = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.96,
				},
				NavigationBar = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
				Scrim = {
					Color3 = Color3.fromRGB(10, 10, 14),
					Transparency = 0.5,
				},
				Shadow = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 0.5,
				},
				Shimmer = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
			},
			Content = {
				Default = {
					Color3 = Color3.fromRGB(73, 77, 90),
					Transparency = 0,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Link = {
					Color3 = Color3.fromRGB(20, 70, 255),
					Transparency = 0,
				},
				Muted = {
					Color3 = Color3.fromRGB(106, 111, 129),
					Transparency = 0,
				},
			},
			Extended = {
				Black = {
					Black_0 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 1,
					},
					Black_03 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.97,
					},
					Black_05 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.95,
					},
					Black_10 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.9,
					},
					Black_15 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.85,
					},
					Black_20 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.8,
					},
					Black_30 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.7,
					},
					Black_40 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.6,
					},
					Black_50 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.5,
					},
					Black_60 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.4,
					},
					Black_70 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.3,
					},
					Black_80 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.2,
					},
					Black_85 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.15,
					},
					Black_90 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.1,
					},
					Black_95 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.05,
					},
					Black_97 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.03,
					},
					Black_100 = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0,
					},
				},
				Blue = {
					Blue_100 = {
						Color3 = Color3.fromRGB(235, 241, 255),
						Transparency = 0,
					},
					Blue_200 = {
						Color3 = Color3.fromRGB(204, 221, 255),
						Transparency = 0,
					},
					Blue_300 = {
						Color3 = Color3.fromRGB(173, 201, 255),
						Transparency = 0,
					},
					Blue_400 = {
						Color3 = Color3.fromRGB(143, 180, 255),
						Transparency = 0,
					},
					Blue_500 = {
						Color3 = Color3.fromRGB(112, 160, 255),
						Transparency = 0,
					},
					Blue_600 = {
						Color3 = Color3.fromRGB(82, 139, 255),
						Transparency = 0,
					},
					Blue_700 = {
						Color3 = Color3.fromRGB(51, 95, 255),
						Transparency = 0,
					},
					Blue_800 = {
						Color3 = Color3.fromRGB(20, 70, 255),
						Transparency = 0,
					},
					Blue_900 = {
						Color3 = Color3.fromRGB(0, 53, 245),
						Transparency = 0,
					},
					Blue_1000 = {
						Color3 = Color3.fromRGB(0, 45, 214),
						Transparency = 0,
					},
					Blue_1100 = {
						Color3 = Color3.fromRGB(0, 39, 184),
						Transparency = 0,
					},
					Blue_1200 = {
						Color3 = Color3.fromRGB(0, 34, 153),
						Transparency = 0,
					},
					Blue_1300 = {
						Color3 = Color3.fromRGB(0, 27, 122),
						Transparency = 0,
					},
					Blue_1400 = {
						Color3 = Color3.fromRGB(0, 20, 92),
						Transparency = 0,
					},
				},
				Gray = {
					Gray_100 = {
						Color3 = Color3.fromRGB(247, 247, 248),
						Transparency = 0,
					},
					Gray_200 = {
						Color3 = Color3.fromRGB(238, 239, 241),
						Transparency = 0,
					},
					Gray_300 = {
						Color3 = Color3.fromRGB(230, 231, 234),
						Transparency = 0,
					},
					Gray_400 = {
						Color3 = Color3.fromRGB(213, 215, 221),
						Transparency = 0,
					},
					Gray_500 = {
						Color3 = Color3.fromRGB(188, 190, 200),
						Transparency = 0,
					},
					Gray_600 = {
						Color3 = Color3.fromRGB(106, 111, 129),
						Transparency = 0,
					},
					Gray_700 = {
						Color3 = Color3.fromRGB(73, 77, 90),
						Transparency = 0,
					},
					Gray_800 = {
						Color3 = Color3.fromRGB(53, 55, 65),
						Transparency = 0,
					},
					Gray_900 = {
						Color3 = Color3.fromRGB(39, 41, 48),
						Transparency = 0,
					},
					Gray_1000 = {
						Color3 = Color3.fromRGB(32, 34, 39),
						Transparency = 0,
					},
					Gray_1100 = {
						Color3 = Color3.fromRGB(25, 26, 31),
						Transparency = 0,
					},
					Gray_1200 = {
						Color3 = Color3.fromRGB(18, 18, 21),
						Transparency = 0,
					},
				},
				Green = {
					Green_100 = {
						Color3 = Color3.fromRGB(208, 251, 227),
						Transparency = 0,
					},
					Green_200 = {
						Color3 = Color3.fromRGB(176, 246, 208),
						Transparency = 0,
					},
					Green_300 = {
						Color3 = Color3.fromRGB(142, 233, 182),
						Transparency = 0,
					},
					Green_400 = {
						Color3 = Color3.fromRGB(101, 215, 157),
						Transparency = 0,
					},
					Green_500 = {
						Color3 = Color3.fromRGB(57, 197, 130),
						Transparency = 0,
					},
					Green_600 = {
						Color3 = Color3.fromRGB(29, 177, 106),
						Transparency = 0,
					},
					Green_700 = {
						Color3 = Color3.fromRGB(12, 155, 90),
						Transparency = 0,
					},
					Green_800 = {
						Color3 = Color3.fromRGB(1, 133, 75),
						Transparency = 0,
					},
					Green_900 = {
						Color3 = Color3.fromRGB(2, 114, 64),
						Transparency = 0,
					},
					Green_1000 = {
						Color3 = Color3.fromRGB(1, 95, 53),
						Transparency = 0,
					},
					Green_1100 = {
						Color3 = Color3.fromRGB(0, 74, 41),
						Transparency = 0,
					},
					Green_1200 = {
						Color3 = Color3.fromRGB(1, 56, 31),
						Transparency = 0,
					},
					Green_1300 = {
						Color3 = Color3.fromRGB(10, 38, 18),
						Transparency = 0,
					},
					Green_1400 = {
						Color3 = Color3.fromRGB(0, 22, 12),
						Transparency = 0,
					},
				},
				Magenta = {
					Magenta_100 = {
						Color3 = Color3.fromRGB(253, 232, 249),
						Transparency = 0,
					},
					Magenta_200 = {
						Color3 = Color3.fromRGB(253, 221, 253),
						Transparency = 0,
					},
					Magenta_300 = {
						Color3 = Color3.fromRGB(245, 200, 252),
						Transparency = 0,
					},
					Magenta_400 = {
						Color3 = Color3.fromRGB(239, 170, 250),
						Transparency = 0,
					},
					Magenta_500 = {
						Color3 = Color3.fromRGB(232, 139, 248),
						Transparency = 0,
					},
					Magenta_600 = {
						Color3 = Color3.fromRGB(223, 106, 247),
						Transparency = 0,
					},
					Magenta_700 = {
						Color3 = Color3.fromRGB(213, 64, 245),
						Transparency = 0,
					},
					Magenta_800 = {
						Color3 = Color3.fromRGB(192, 10, 232),
						Transparency = 0,
					},
					Magenta_900 = {
						Color3 = Color3.fromRGB(165, 14, 200),
						Transparency = 0,
					},
					Magenta_1000 = {
						Color3 = Color3.fromRGB(138, 12, 167),
						Transparency = 0,
					},
					Magenta_1100 = {
						Color3 = Color3.fromRGB(110, 7, 133),
						Transparency = 0,
					},
					Magenta_1200 = {
						Color3 = Color3.fromRGB(84, 4, 103),
						Transparency = 0,
					},
					Magenta_1300 = {
						Color3 = Color3.fromRGB(60, 2, 74),
						Transparency = 0,
					},
					Magenta_1400 = {
						Color3 = Color3.fromRGB(35, 4, 42),
						Transparency = 0,
					},
				},
				Orange = {
					Orange_100 = {
						Color3 = Color3.fromRGB(253, 232, 216),
						Transparency = 0,
					},
					Orange_200 = {
						Color3 = Color3.fromRGB(252, 222, 199),
						Transparency = 0,
					},
					Orange_300 = {
						Color3 = Color3.fromRGB(251, 206, 174),
						Transparency = 0,
					},
					Orange_400 = {
						Color3 = Color3.fromRGB(251, 178, 134),
						Transparency = 0,
					},
					Orange_500 = {
						Color3 = Color3.fromRGB(250, 148, 90),
						Transparency = 0,
					},
					Orange_600 = {
						Color3 = Color3.fromRGB(245, 118, 48),
						Transparency = 0,
					},
					Orange_700 = {
						Color3 = Color3.fromRGB(220, 100, 35),
						Transparency = 0,
					},
					Orange_800 = {
						Color3 = Color3.fromRGB(192, 80, 20),
						Transparency = 0,
					},
					Orange_900 = {
						Color3 = Color3.fromRGB(169, 67, 11),
						Transparency = 0,
					},
					Orange_1000 = {
						Color3 = Color3.fromRGB(144, 51, 0),
						Transparency = 0,
					},
					Orange_1100 = {
						Color3 = Color3.fromRGB(115, 40, 0),
						Transparency = 0,
					},
					Orange_1200 = {
						Color3 = Color3.fromRGB(87, 30, 0),
						Transparency = 0,
					},
					Orange_1300 = {
						Color3 = Color3.fromRGB(60, 21, 0),
						Transparency = 0,
					},
					Orange_1400 = {
						Color3 = Color3.fromRGB(33, 13, 1),
						Transparency = 0,
					},
				},
				Pink = {
					Pink_100 = {
						Color3 = Color3.fromRGB(255, 230, 242),
						Transparency = 0,
					},
					Pink_200 = {
						Color3 = Color3.fromRGB(254, 220, 236),
						Transparency = 0,
					},
					Pink_300 = {
						Color3 = Color3.fromRGB(250, 202, 224),
						Transparency = 0,
					},
					Pink_400 = {
						Color3 = Color3.fromRGB(247, 173, 207),
						Transparency = 0,
					},
					Pink_500 = {
						Color3 = Color3.fromRGB(243, 143, 184),
						Transparency = 0,
					},
					Pink_600 = {
						Color3 = Color3.fromRGB(238, 114, 161),
						Transparency = 0,
					},
					Pink_700 = {
						Color3 = Color3.fromRGB(231, 78, 144),
						Transparency = 0,
					},
					Pink_800 = {
						Color3 = Color3.fromRGB(205, 55, 123),
						Transparency = 0,
					},
					Pink_900 = {
						Color3 = Color3.fromRGB(180, 43, 106),
						Transparency = 0,
					},
					Pink_1000 = {
						Color3 = Color3.fromRGB(153, 29, 88),
						Transparency = 0,
					},
					Pink_1100 = {
						Color3 = Color3.fromRGB(99, 3, 53),
						Transparency = 0,
					},
					Pink_1200 = {
						Color3 = Color3.fromRGB(99, 3, 53),
						Transparency = 0,
					},
					Pink_1300 = {
						Color3 = Color3.fromRGB(70, 4, 36),
						Transparency = 0,
					},
					Pink_1400 = {
						Color3 = Color3.fromRGB(43, 2, 21),
						Transparency = 0,
					},
				},
				Purple = {
					Purple_100 = {
						Color3 = Color3.fromRGB(241, 231, 255),
						Transparency = 0,
					},
					Purple_200 = {
						Color3 = Color3.fromRGB(233, 222, 251),
						Transparency = 0,
					},
					Purple_300 = {
						Color3 = Color3.fromRGB(226, 206, 253),
						Transparency = 0,
					},
					Purple_400 = {
						Color3 = Color3.fromRGB(212, 181, 252),
						Transparency = 0,
					},
					Purple_500 = {
						Color3 = Color3.fromRGB(197, 156, 249),
						Transparency = 0,
					},
					Purple_600 = {
						Color3 = Color3.fromRGB(182, 130, 247),
						Transparency = 0,
					},
					Purple_700 = {
						Color3 = Color3.fromRGB(167, 102, 245),
						Transparency = 0,
					},
					Purple_800 = {
						Color3 = Color3.fromRGB(147, 72, 240),
						Transparency = 0,
					},
					Purple_900 = {
						Color3 = Color3.fromRGB(130, 46, 231),
						Transparency = 0,
					},
					Purple_1000 = {
						Color3 = Color3.fromRGB(108, 33, 198),
						Transparency = 0,
					},
					Purple_1100 = {
						Color3 = Color3.fromRGB(86, 20, 165),
						Transparency = 0,
					},
					Purple_1200 = {
						Color3 = Color3.fromRGB(65, 8, 134),
						Transparency = 0,
					},
					Purple_1300 = {
						Color3 = Color3.fromRGB(45, 4, 96),
						Transparency = 0,
					},
					Purple_1400 = {
						Color3 = Color3.fromRGB(28, 2, 59),
						Transparency = 0,
					},
				},
				Red = {
					Red_100 = {
						Color3 = Color3.fromRGB(255, 234, 233),
						Transparency = 0,
					},
					Red_200 = {
						Color3 = Color3.fromRGB(255, 223, 222),
						Transparency = 0,
					},
					Red_300 = {
						Color3 = Color3.fromRGB(247, 205, 203),
						Transparency = 0,
					},
					Red_400 = {
						Color3 = Color3.fromRGB(243, 178, 174),
						Transparency = 0,
					},
					Red_500 = {
						Color3 = Color3.fromRGB(238, 151, 145),
						Transparency = 0,
					},
					Red_600 = {
						Color3 = Color3.fromRGB(235, 121, 115),
						Transparency = 0,
					},
					Red_700 = {
						Color3 = Color3.fromRGB(231, 87, 80),
						Transparency = 0,
					},
					Red_800 = {
						Color3 = Color3.fromRGB(223, 40, 31),
						Transparency = 0,
					},
					Red_900 = {
						Color3 = Color3.fromRGB(197, 18, 10),
						Transparency = 0,
					},
					Red_1000 = {
						Color3 = Color3.fromRGB(164, 17, 9),
						Transparency = 0,
					},
					Red_1100 = {
						Color3 = Color3.fromRGB(131, 15, 7),
						Transparency = 0,
					},
					Red_1200 = {
						Color3 = Color3.fromRGB(100, 12, 5),
						Transparency = 0,
					},
					Red_1300 = {
						Color3 = Color3.fromRGB(71, 8, 4),
						Transparency = 0,
					},
					Red_1400 = {
						Color3 = Color3.fromRGB(40, 6, 3),
						Transparency = 0,
					},
				},
				Turquoise = {
					Turquoise_100 = {
						Color3 = Color3.fromRGB(200, 246, 255),
						Transparency = 0,
					},
					Turquoise_200 = {
						Color3 = Color3.fromRGB(163, 239, 254),
						Transparency = 0,
					},
					Turquoise_300 = {
						Color3 = Color3.fromRGB(126, 229, 248),
						Transparency = 0,
					},
					Turquoise_400 = {
						Color3 = Color3.fromRGB(92, 210, 232),
						Transparency = 0,
					},
					Turquoise_500 = {
						Color3 = Color3.fromRGB(57, 189, 216),
						Transparency = 0,
					},
					Turquoise_600 = {
						Color3 = Color3.fromRGB(22, 169, 199),
						Transparency = 0,
					},
					Turquoise_700 = {
						Color3 = Color3.fromRGB(4, 148, 178),
						Transparency = 0,
					},
					Turquoise_800 = {
						Color3 = Color3.fromRGB(18, 125, 152),
						Transparency = 0,
					},
					Turquoise_900 = {
						Color3 = Color3.fromRGB(5, 108, 130),
						Transparency = 0,
					},
					Turquoise_1000 = {
						Color3 = Color3.fromRGB(5, 90, 106),
						Transparency = 0,
					},
					Turquoise_1100 = {
						Color3 = Color3.fromRGB(4, 71, 84),
						Transparency = 0,
					},
					Turquoise_1200 = {
						Color3 = Color3.fromRGB(2, 53, 63),
						Transparency = 0,
					},
					Turquoise_1300 = {
						Color3 = Color3.fromRGB(2, 37, 44),
						Transparency = 0,
					},
					Turquoise_1400 = {
						Color3 = Color3.fromRGB(2, 20, 24),
						Transparency = 0,
					},
				},
				White = {
					White_0 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 1,
					},
					White_03 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.97,
					},
					White_05 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.95,
					},
					White_10 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.9,
					},
					White_15 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.85,
					},
					White_20 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.8,
					},
					White_30 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.7,
					},
					White_40 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.6,
					},
					White_50 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.5,
					},
					White_60 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.4,
					},
					White_70 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.3,
					},
					White_80 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.2,
					},
					White_85 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.15,
					},
					White_90 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.1,
					},
					White_95 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.05,
					},
					White_97 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.03,
					},
					White_100 = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0,
					},
				},
				Yellow = {
					Yellow_100 = {
						Color3 = Color3.fromRGB(253, 236, 193),
						Transparency = 0,
					},
					Yellow_200 = {
						Color3 = Color3.fromRGB(250, 228, 170),
						Transparency = 0,
					},
					Yellow_300 = {
						Color3 = Color3.fromRGB(247, 210, 115),
						Transparency = 0,
					},
					Yellow_400 = {
						Color3 = Color3.fromRGB(242, 186, 42),
						Transparency = 0,
					},
					Yellow_500 = {
						Color3 = Color3.fromRGB(219, 166, 31),
						Transparency = 0,
					},
					Yellow_600 = {
						Color3 = Color3.fromRGB(196, 147, 21),
						Transparency = 0,
					},
					Yellow_700 = {
						Color3 = Color3.fromRGB(174, 128, 11),
						Transparency = 0,
					},
					Yellow_800 = {
						Color3 = Color3.fromRGB(151, 108, 0),
						Transparency = 0,
					},
					Yellow_900 = {
						Color3 = Color3.fromRGB(129, 93, 0),
						Transparency = 0,
					},
					Yellow_1000 = {
						Color3 = Color3.fromRGB(107, 76, 0),
						Transparency = 0,
					},
					Yellow_1100 = {
						Color3 = Color3.fromRGB(83, 61, 2),
						Transparency = 0,
					},
					Yellow_1200 = {
						Color3 = Color3.fromRGB(63, 45, 1),
						Transparency = 0,
					},
					Yellow_1300 = {
						Color3 = Color3.fromRGB(44, 31, 0),
						Transparency = 0,
					},
					Yellow_1400 = {
						Color3 = Color3.fromRGB(24, 17, 0),
						Transparency = 0,
					},
				},
			},
			None = {
				Color3 = Color3.fromRGB(0, 0, 0),
				Transparency = 1,
			},
			OverMedia = {
				OverMedia_0 = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0.08,
				},
				OverMedia_100 = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0.08,
				},
				OverMedia_200 = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0.08,
				},
				OverMedia_300 = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0.08,
				},
			},
			Selection = {
				End = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Start = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
			},
			Shift = {
				Shift_100 = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.96,
				},
				Shift_200 = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.92,
				},
				Shift_300 = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
				Shift_400 = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.84,
				},
			},
			State = {
				Hover = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.92,
				},
				Idle = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Press = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
			},
			Stroke = {
				Default = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.84,
				},
				Muted = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.92,
				},
			},
			Surface = {
				Surface_0 = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
				Surface_100 = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Surface_200 = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
				Surface_300 = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			System = {
				Alert = {
					Color3 = Color3.fromRGB(223, 40, 31),
					Transparency = 0,
				},
				Contrast = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Neutral = {
					Color3 = Color3.fromRGB(73, 77, 90),
					Transparency = 0,
				},
				Success = {
					Color3 = Color3.fromRGB(57, 197, 130),
					Transparency = 0,
				},
				Warning = {
					Color3 = Color3.fromRGB(242, 186, 42),
					Transparency = 0,
				},
			},
		},
		Component = {
			BaseMenu = {
				BackgroundColor = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				BorderRadius = 8 * scale,
			},
			ControllerBar = {
				BackgroundColor = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.96,
				},
				BorderRadius = {
					LeadingBottom = 9999,
					LeadingTop = 9999,
					TrailingBottom = 9999,
					TrailingTop = 9999,
				},
				Gap = 16 * scale,
				Spacing = {
					Bottom = 8 * scale,
					Leading = 12 * scale,
					Top = 8 * scale,
					Trailing = 12 * scale,
				},
			},
			ControllerBarShortcut = {
				Container = {
					ContentColor = {
						Color3 = Color3.fromRGB(32, 34, 39),
						Transparency = 0,
					},
					Gap = 4 * scale,
				},
				Icon = {
					Size = 36 * scale,
				},
				Label = {
					Typography = {
						Font = Enum.Font.BuilderSansMedium,
						FontSize = 17.640 * scale,
						LetterSpacing = 0,
						LineHeight = 1.111,
					},
				},
			},
			Facepile = {
				Badge = {
					BackgroundColor = {
						Color3 = Color3.fromRGB(51, 95, 255),
						Transparency = 0,
					},
					BorderColor = {
						Color3 = Color3.fromRGB(247, 247, 248),
						Transparency = 0,
					},
					BorderRadius = 9999,
					BorderWidth = 2 * scale,
					ContentColor = {
						Color3 = Color3.fromRGB(247, 247, 248),
						Transparency = 0,
					},
					Height = 16 * scale,
					MinWidth = 16 * scale,
					Spacing = 4 * scale,
					Typography = {
						Font = Enum.Font.BuilderSansMedium,
						FontSize = 12.600 * scale,
						LetterSpacing = 0,
						LineHeight = 1.111,
					},
				},
				Container = {
					Gap = 4 * scale,
				},
				Face = {
					BackgroundColor = {
						Color3 = Color3.fromRGB(73, 77, 90),
						Transparency = 0,
					},
					BorderColor = {
						Color3 = Color3.fromRGB(247, 247, 248),
						Transparency = 0,
					},
					BorderRadius = 9999,
					BorderWidth = 2 * scale,
					Height = 16 * scale,
					Width = 16 * scale,
				},
				FaceGroup = {
					Gap = -6 * scale,
				},
				Label = {
					ContentColor = {
						Color3 = Color3.fromRGB(106, 111, 129),
						Transparency = 0,
					},
					Typography = {
						Font = Enum.Font.BuilderSans,
						FontSize = 15.120 * scale,
						LetterSpacing = 0,
						LineHeight = 1.111,
					},
				},
			},
			HelperText = {
				Base = {
					ContentColor = {
						Color3 = Color3.fromRGB(73, 77, 90),
						Transparency = 0,
					},
					Opacity = 1,
					Padding = {
						Top = 4 * scale,
					},
					Typography = {
						Font = Enum.Font.BuilderSansMedium,
						FontSize = 12.600 * scale,
						LetterSpacing = 0,
						LineHeight = 1.111,
					},
				},
				Error = {
					ContentColor = {
						Color3 = Color3.fromRGB(217, 28, 21),
						Transparency = 0,
					},
				},
			},
			InputLabel = {
				Base = {
					ContentColor = {
						Color3 = Color3.fromRGB(73, 77, 90),
						Transparency = 0,
					},
					Opacity = 1,
					Spacing = {
						Bottom = 4 * scale,
					},
					Typography = {
						Font = Enum.Font.BuilderSans,
						FontSize = 15.120 * scale,
						LetterSpacing = 0,
						LineHeight = 1.111,
					},
				},
				Disabled = {
					Opacity = 0.32,
				},
			},
			MediaTile = {
				Container = {
					BorderRadius = 8 * scale,
				},
				Icon = {
					Size = 36 * scale,
				},
			},
			MenuCell = {
				Base = {
					CheckFrame = {
						Size = 32 * scale,
					},
					Container = {
						BackgroundColor = {
							Color3 = Color3.fromRGB(247, 247, 248),
							Transparency = 0,
						},
						BorderColor = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.84,
						},
						BorderRadius = {
							BottomLeading = 0,
							BottomTrailing = 0,
							TopLeading = 0,
							TopTrailing = 0,
						},
						BorderWidth = 0,
						ContentColor = {
							Color3 = Color3.fromRGB(32, 34, 39),
							Transparency = 0,
						},
						Height = 56 * scale,
						Spacing = {
							Bottom = 0,
							Leading = 12 * scale,
							Top = 0,
							Trailing = 12 * scale,
						},
					},
					IconFrame = {
						Size = 32 * scale,
					},
					Text = {
						Typography = {
							Font = Enum.Font.BuilderSansBold,
							FontSize = 20.160 * scale,
							LetterSpacing = 0,
							LineHeight = 1.111,
						},
					},
					TextFrame = {
						Spacing = {
							Bottom = 0,
							Leading = 12 * scale,
							Top = 0,
							Trailing = 12 * scale,
						},
					},
				},
				Disabled = {
					Container = {
						ContentColor = {
							Color3 = Color3.fromRGB(32, 34, 39),
							Transparency = 0.5,
						},
					},
				},
				Divider = {
					Container = {
						BorderWidth = 1 * scale,
					},
				},
				HasRoundBottom = {
					Container = {
						BorderRadius = {
							BottomLeading = 8 * scale,
							BottomTrailing = 8 * scale,
						},
					},
				},
				HasRoundTop = {
					Container = {
						BorderRadius = {
							TopLeading = 8 * scale,
							TopTrailing = 8 * scale,
						},
					},
				},
			},
			PlayerCount = {
				Container = {
					BackgroundColor = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 1,
					},
					BorderRadius = 0,
					Spacing = 8 * scale,
				},
			},
			PlayerTileSmall = {
				Base = {
					Container = {
						Gap = 8 * scale,
						Spacing = {
							Bottom = 8 * scale,
							Leading = 8 * scale,
							Top = 8 * scale,
							Trailing = 8 * scale,
						},
					},
					Content = {
						ContentColor = {
							Color3 = Color3.fromRGB(32, 34, 39),
							Transparency = 0,
						},
						Gap = 2 * scale,
						Typography = {
							Font = Enum.Font.BuilderSansMedium,
							FontSize = 17.640 * scale,
							LetterSpacing = 0,
							LineHeight = 1.111,
						},
					},
					Icon = {
						Size = 16 * scale,
					},
					Image = {
						BackgroundColor = {
							Color3 = Color3.fromRGB(247, 247, 248),
							Transparency = 0,
						},
						BorderColor = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.84,
						},
						BorderRadius = 9999,
						BorderWidth = 3 * scale,
						Size = 96 * scale,
					},
					Presence = {
						ContentColor = {
							Color3 = Color3.fromRGB(73, 77, 90),
							Transparency = 0,
						},
					},
					Status = {
						BackgroundColor = {
							Color3 = Color3.fromRGB(57, 197, 130),
							Transparency = 0,
						},
						BorderColor = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 0,
						},
						BorderWidth = 2.500 * scale,
						Size = 16 * scale,
					},
				},
			},
			RateCount = {
				ButtonGroup = {
					Gap = 8 * scale,
				},
				Container = {
					BackgroundColor = {
						Color3 = Color3.fromRGB(27, 37, 75),
						Transparency = 0.84,
					},
					BorderRadius = 8 * scale,
					Gap = 8 * scale,
					Spacing = 8 * scale,
				},
			},
			SelectionCursor = {
				BorderWidth = 3 * scale,
				Gradient = {
					End = {
						Color3 = Color3.fromRGB(51, 95, 255),
						Transparency = 0,
					},
					Start = {
						Color3 = Color3.fromRGB(51, 95, 255),
						Transparency = 0,
					},
				},
				Inset = 0,
				Offset = 6 * scale,
			},
			StatGroup = {
				Gap = 8 * scale,
			},
			StatItem = {
				Container = {
					ContentColor = {
						Color3 = Color3.fromRGB(106, 111, 129),
						Transparency = 0,
					},
					Gap = 2 * scale,
				},
				Icon = {
					Size = 16 * scale,
				},
				Label = {
					Typography = {
						Font = Enum.Font.BuilderSans,
						FontSize = 15.120 * scale,
						LetterSpacing = 0,
						LineHeight = 1.111,
					},
				},
			},
			StatWidget = {
				Container = {
					ContentColor = {
						Color3 = Color3.fromRGB(32, 34, 39),
						Transparency = 0,
					},
					Gap = 8 * scale,
				},
				Data = {
					Typography = {
						Font = Enum.Font.BuilderSansBold,
						FontSize = 35.280 * scale,
						LetterSpacing = -0.01,
						LineHeight = 0.952,
					},
				},
				DataGroup = {
					Gap = 0,
				},
				Icon = {
					Size = 48 * scale,
				},
				Label = {
					Typography = {
						Font = Enum.Font.BuilderSansBold,
						FontSize = 20.160 * scale,
						LetterSpacing = 0,
						LineHeight = 1.111,
					},
				},
			},
			StateLayer = {
				Base = {
					BorderWidth = 1 * scale,
				},
				Darken = {
					Default = {
						Color = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
					Disabled = {
						Color = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
					Hover = {
						Color = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.92,
						},
					},
					Initialize = {
						Color = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
					Pressed = {
						Color = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.88,
						},
					},
					Selected = {
						Color = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
					SelectedPressed = {
						Color = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.88,
						},
					},
				},
				Inverse = {
					Default = {
						Color = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
					},
					Disabled = {
						Color = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
					},
					Hover = {
						Color = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.92,
						},
					},
					Initialize = {
						Color = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
					},
					Pressed = {
						Color = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.88,
						},
					},
					Selected = {
						Color = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
					},
					SelectedPressed = {
						Color = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.88,
						},
					},
				},
				Lighten = {
					Default = {
						Color = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
					},
					Disabled = {
						Color = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
					},
					Hover = {
						Color = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.92,
						},
					},
					Initialize = {
						Color = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
					},
					Pressed = {
						Color = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.88,
						},
					},
					Selected = {
						Color = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
					},
					SelectedPressed = {
						Color = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.88,
						},
					},
				},
				Standard = {
					Default = {
						Color = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
					Disabled = {
						Color = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
					Hover = {
						Color = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.92,
						},
					},
					Initialize = {
						Color = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
					Pressed = {
						Color = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.88,
						},
					},
					Selected = {
						Color = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
					SelectedPressed = {
						Color = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.88,
						},
					},
				},
			},
			TextField = {
				Base = {
					Field = {
						BorderColor = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.84,
						},
						BorderRadius = 8 * scale,
						Gap = 8 * scale,
						Opacity = 1,
						Spacing = {
							Leading = 12 * scale,
							Trailing = 12 * scale,
						},
						Typography = {
							Font = Enum.Font.BuilderSans,
							FontSize = 20.160 * scale,
							LetterSpacing = 0,
							LineHeight = 1.111,
						},
					},
					FieldValue = {
						ContentColor = {
							Color3 = Color3.fromRGB(32, 34, 39),
							Transparency = 0,
						},
					},
					IconLeading = {
						ContentColor = {
							Color3 = Color3.fromRGB(106, 111, 129),
							Transparency = 0,
						},
						Size = 16 * scale,
					},
					PlaceholderText = {
						ContentColor = {
							Color3 = Color3.fromRGB(106, 111, 129),
							Transparency = 0,
						},
					},
				},
				Disabled = {
					Field = {
						Opacity = 0.32,
					},
				},
				Error = {
					Field = {
						BorderColor = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
					},
				},
			},
			VerticalScrollView = {
				Base = {
					Handle = {
						BackgroundColor = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.84,
						},
						BorderRadius = 9999,
						ContentColor = {
							Color3 = Color3.fromRGB(32, 34, 39),
							Transparency = 0,
						},
					},
					Icon = {
						Size = 36 * scale,
					},
					Track = {
						Opacity = 0,
						Spacing = {
							Bottom = 4 * scale,
							Top = 4 * scale,
						},
					},
				},
				Compact = {
					Handle = {
						Width = 2 * scale,
					},
					Track = {
						Width = 12 * scale,
					},
				},
				Gamepad = {
					Handle = {
						Width = 16 * scale,
					},
					Track = {
						Width = 16 * scale,
					},
				},
				Wide = {
					Handle = {
						Width = 8 * scale,
					},
					Track = {
						Width = 16 * scale,
					},
				},
			},
			VerticalTile = {
				Base = {
					Container = {
						Background = {
							Color3 = Color3.fromRGB(247, 247, 248),
							Transparency = 0,
						},
						BorderColor = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.84,
						},
						BorderRadius = {
							LeadingBottom = 8 * scale,
							LeadingTop = 8 * scale,
							TrailingBottom = 8 * scale,
							TrailingTop = 8 * scale,
						},
						BorderWidth = 1 * scale,
						DropShadow = {
							Blur = 8 * scale,
							Color = {
								Color3 = Color3.fromRGB(10, 10, 14),
								Transparency = 0.5,
							},
							X = 0,
							Y = 4 * scale,
						},
					},
					ContentBottom = {
						Spacing = {
							Bottom = 8 * scale,
							Leading = 8 * scale,
							Top = 8 * scale,
							Trailing = 8 * scale,
						},
					},
					ContentTop = {
						Spacing = {
							Bottom = 0,
							Leading = 0,
							Top = 0,
							Trailing = 0,
						},
					},
				},
			},
		},
		Config = {
			ColorMode = {
				IsDark = "false",
				IsLight = "true",
				Name = "Light",
			},
			Text = {
				Font = "Builder Sans",
				Interval = 5.040,
				InverseScale = 1 / 1.26,
				NominalScale = 1.26,
				Scale = 1,
			},
			Theme = {
				IsFoundation = "true",
				IsUIBlox = "false",
				Name = "Foundation",
			},
			UI = {
				Interval = 4,
				Scale = 1,
				StrokeBase = 1,
			},
		},
		DarkMode = {
			ActionAlert = {
				Background = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(240, 68, 51),
					Transparency = 0,
				},
			},
			ActionEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionLink = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionOverMedia = {
				Background = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionSoftEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0.6,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(235, 241, 255),
					Transparency = 0,
				},
			},
			ActionStandard = {
				Background = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionSubEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionSubtle = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(213, 215, 221),
					Transparency = 0,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionUtility = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			Common = {
				Backdrop = {
					Color3 = Color3.fromRGB(10, 10, 14),
					Transparency = 0.25,
				},
				HeavyDivider = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 0.5,
				},
				NavigationBar = {
					Color3 = Color3.fromRGB(18, 18, 21),
					Transparency = 0,
				},
				Scrim = {
					Color3 = Color3.fromRGB(10, 10, 14),
					Transparency = 0.25,
				},
				Shadow = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 0.5,
				},
				Shimmer = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
			},
			Content = {
				Default = {
					Color3 = Color3.fromRGB(213, 215, 221),
					Transparency = 0,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Link = {
					Color3 = Color3.fromRGB(82, 139, 255),
					Transparency = 0,
				},
				Muted = {
					Color3 = Color3.fromRGB(188, 190, 200),
					Transparency = 0,
				},
			},
			None = {
				Color3 = Color3.fromRGB(0, 0, 0),
				Transparency = 1,
			},
			OverMedia = {
				OverMedia_0 = {
					Color3 = Color3.fromRGB(18, 18, 21),
					Transparency = 0.08,
				},
				OverMedia_100 = {
					Color3 = Color3.fromRGB(25, 26, 31),
					Transparency = 0.08,
				},
				OverMedia_200 = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0.08,
				},
				OverMedia_300 = {
					Color3 = Color3.fromRGB(39, 41, 48),
					Transparency = 0.08,
				},
			},
			Selection = {
				End = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
				Start = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
			},
			Shift = {
				Shift_100 = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.96,
				},
				Shift_200 = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.92,
				},
				Shift_300 = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
				Shift_400 = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.84,
				},
			},
			State = {
				Hover = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.92,
				},
				Idle = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 1,
				},
				Press = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
			},
			Stroke = {
				Default = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.84,
				},
				Muted = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.92,
				},
			},
			Surface = {
				Surface_0 = {
					Color3 = Color3.fromRGB(18, 18, 21),
					Transparency = 0,
				},
				Surface_100 = {
					Color3 = Color3.fromRGB(25, 26, 31),
					Transparency = 0,
				},
				Surface_200 = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Surface_300 = {
					Color3 = Color3.fromRGB(39, 41, 48),
					Transparency = 0,
				},
			},
			System = {
				Alert = {
					Color3 = Color3.fromRGB(223, 40, 31),
					Transparency = 0,
				},
				Contrast = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Neutral = {
					Color3 = Color3.fromRGB(188, 190, 200),
					Transparency = 0,
				},
				Success = {
					Color3 = Color3.fromRGB(57, 197, 130),
					Transparency = 0,
				},
				Warning = {
					Color3 = Color3.fromRGB(242, 186, 42),
					Transparency = 0,
				},
			},
		},
		Ease = {
			ExpressiveIn = {
				0.25,
				0,
				0.5,
				-1,
			},
			ExpressiveOut = {
				0.25,
				1.5,
				0.5,
				1,
			},
			Linear = {
				0,
				0,
				1,
				1,
			},
			StandardIn = {
				0.8,
				0,
				0.4,
				1,
			},
			StandardOut = {
				0.2,
				0,
				0,
				1,
			},
		},
		FontSize = {
			FontSize_200 = 10.080 * scale,
			FontSize_250 = 12.600 * scale,
			FontSize_300 = 15.120 * scale,
			FontSize_350 = 17.640 * scale,
			FontSize_400 = 20.160 * scale,
			FontSize_500 = 25.200 * scale,
			FontSize_600 = 30.240 * scale,
			FontSize_700 = 35.280 * scale,
			FontSize_800 = 40.320 * scale,
			FontSize_900 = 45.360 * scale,
			FontSize_1000 = 50.400 * scale,
			FontSize_1100 = 55.440 * scale,
			FontSize_1200 = 60.480 * scale,
			FontSize_1300 = 65.520 * scale,
			FontSize_1400 = 70.560 * scale,
			FontSize_1500 = 75.600 * scale,
			FontSize_1600 = 80.640 * scale,
			FontSize_1700 = 85.680 * scale,
			FontSize_1800 = 90.720 * scale,
			FontSize_1900 = 95.760 * scale,
			FontSize_2000 = 100.800 * scale,
			FontSize_2100 = 105.840 * scale,
			FontSize_2200 = 110.880 * scale,
			FontSize_2300 = 115.920 * scale,
			FontSize_2400 = 120.960 * scale,
			FontSize_2500 = 126 * scale,
			FontSize_2600 = 131.040 * scale,
			FontSize_2700 = 136.080 * scale,
			FontSize_2800 = 141.120 * scale,
			FontSize_2900 = 146.160 * scale,
			FontSize_3000 = 151.200 * scale,
		},
		FontWeight = {
			FontWeight_300 = "Light",
			FontWeight_400 = "Regular",
			FontWeight_500 = "Medium",
			FontWeight_600 = "SemiBold",
			FontWeight_700 = "Bold",
			FontWeight_800 = "ExtraBold",
		},
		Gap = {
			Large = 16 * scale,
			Medium = 12 * scale,
			None = 0,
			Small = 8 * scale,
			XLarge = 20 * scale,
			XSmall = 4 * scale,
			XXLarge = 24 * scale,
			XXSmall = 2 * scale,
		},
		Global = {
			Color = {
				Alabaster = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Ash = {
					Color3 = Color3.fromRGB(230, 231, 234),
					Transparency = 0,
				},
				Black = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 0,
				},
				Blue = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Carbon = {
					Color3 = Color3.fromRGB(25, 26, 31),
					Transparency = 0,
				},
				Chalk = {
					Color3 = Color3.fromRGB(213, 215, 221),
					Transparency = 0,
				},
				Flint = {
					Color3 = Color3.fromRGB(39, 41, 48),
					Transparency = 0,
				},
				Graphite = {
					Color3 = Color3.fromRGB(73, 77, 90),
					Transparency = 0,
				},
				Green = {
					Color3 = Color3.fromRGB(57, 197, 130),
					Transparency = 0,
				},
				None = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Obsidian = {
					Color3 = Color3.fromRGB(18, 18, 21),
					Transparency = 0,
				},
				Pumice = {
					Color3 = Color3.fromRGB(188, 190, 200),
					Transparency = 0,
				},
				Red = {
					Color3 = Color3.fromRGB(223, 40, 31),
					Transparency = 0,
				},
				Slate = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Smoke = {
					Color3 = Color3.fromRGB(53, 55, 65),
					Transparency = 0,
				},
				White = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
			},
			Family = {
				Standard = "Builder Sans",
			},
			FontSize_25 = 10 * scale,
			FontSize_50 = 12 * scale,
			FontSize_75 = 14 * scale,
			FontSize_100 = 16 * scale,
			FontSize_200 = 20 * scale,
			FontSize_300 = 24 * scale,
			FontSize_400 = 28 * scale,
			FontSize_500 = 34 * scale,
			FontSize_600 = 40 * scale,
			FontSize_700 = 48 * scale,
			FontSize_800 = 58 * scale,
			FontSize_900 = 68 * scale,
			FontSize_1000 = 82 * scale,
			LetterSpacing = {
				Default = 0,
			},
			LineHeight_100 = 0.794,
			LineHeight_200 = 0.952,
			LineHeight_300 = 1.032,
			LineHeight_400 = 1.111,
			Opacity_0 = 1,
			Opacity_8 = 0.92,
			Opacity_12 = 0.88,
			Opacity_16 = 0.84,
			Opacity_32 = 0.68,
			Opacity_68 = 0.32,
			Opacity_84 = 0.16,
			Opacity_88 = 0.12,
			Opacity_92 = 0.08,
			Opacity_100 = 0,
			Size_0 = 0,
			Size_25 = 2 * scale,
			Size_50 = 4 * scale,
			Size_75 = 6 * scale,
			Size_100 = 8 * scale,
			Size_150 = 12 * scale,
			Size_200 = 16 * scale,
			Size_250 = 20 * scale,
			Size_300 = 24 * scale,
			Size_350 = 28 * scale,
			Size_400 = 32 * scale,
			Size_450 = 36 * scale,
			Size_500 = 40 * scale,
			Size_600 = 48 * scale,
			Size_700 = 56 * scale,
			Size_800 = 64 * scale,
			Size_900 = 72 * scale,
			Size_1000 = 80 * scale,
			Size_1100 = 88 * scale,
			Size_1200 = 96 * scale,
			Size_1300 = 104 * scale,
			Size_1400 = 112 * scale,
			Space_0 = 0,
			Space_25 = 2 * scale,
			Space_50 = 4 * scale,
			Space_75 = 6 * scale,
			Space_100 = 8 * scale,
			Space_150 = 12 * scale,
			Space_200 = 16 * scale,
			Space_250 = 20 * scale,
			Space_300 = 24 * scale,
			Space_400 = 32 * scale,
			Space_500 = 40 * scale,
			Space_600 = 48 * scale,
			Space_800 = 64 * scale,
			Space_1000 = 80 * scale,
			Stroke_50 = 0.500 * scale,
			Stroke_100 = 1 * scale,
			Stroke_150 = 1.500 * scale,
			Stroke_200 = 2 * scale,
			Stroke_250 = 2.500 * scale,
			Stroke_300 = 3 * scale,
			Stroke_400 = 4 * scale,
			Weight_300 = "Light",
			Weight_400 = "Regular",
			Weight_600 = "Medium",
			Weight_700 = "Bold",
			Weight_900 = "ExtraBold",
		},
		Gutter = {
			Large = 16 * scale,
			Medium = 12 * scale,
			None = 0,
			Small = 8 * scale,
			XLarge = 20 * scale,
			XXLarge = 24 * scale,
		},
		IconSize = {
			Large = 24 * scale,
			Medium = 20 * scale,
			Small = 16 * scale,
			XLarge = 28 * scale,
			XSmall = 12 * scale,
		},
		InputSize = {
			Large = 48 * scale,
			Medium = 40 * scale,
			Small = 32 * scale,
			XSmall = 24 * scale,
		},
		Inverse = {
			ActionAlert = {
				Background = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(240, 68, 51),
					Transparency = 0,
				},
			},
			ActionEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionLink = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionOverMedia = {
				Background = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionSoftEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0.6,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(235, 241, 255),
					Transparency = 0,
				},
			},
			ActionStandard = {
				Background = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionSubEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionSubtle = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(213, 215, 221),
					Transparency = 0,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionUtility = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			Common = {
				Backdrop = {
					Color3 = Color3.fromRGB(10, 10, 14),
					Transparency = 0.25,
				},
				HeavyDivider = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 0.5,
				},
				NavigationBar = {
					Color3 = Color3.fromRGB(18, 18, 21),
					Transparency = 0,
				},
				Scrim = {
					Color3 = Color3.fromRGB(10, 10, 14),
					Transparency = 0.25,
				},
				Shadow = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 0.5,
				},
				Shimmer = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
			},
			Content = {
				Default = {
					Color3 = Color3.fromRGB(213, 215, 221),
					Transparency = 0,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Link = {
					Color3 = Color3.fromRGB(82, 139, 255),
					Transparency = 0,
				},
				Muted = {
					Color3 = Color3.fromRGB(188, 190, 200),
					Transparency = 0,
				},
			},
			None = {
				Color3 = Color3.fromRGB(0, 0, 0),
				Transparency = 1,
			},
			OverMedia = {
				OverMedia_0 = {
					Color3 = Color3.fromRGB(18, 18, 21),
					Transparency = 0.08,
				},
				OverMedia_100 = {
					Color3 = Color3.fromRGB(25, 26, 31),
					Transparency = 0.08,
				},
				OverMedia_200 = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0.08,
				},
				OverMedia_300 = {
					Color3 = Color3.fromRGB(39, 41, 48),
					Transparency = 0.08,
				},
			},
			Selection = {
				End = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
				Start = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
			},
			Shift = {
				Shift_100 = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.96,
				},
				Shift_200 = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.92,
				},
				Shift_300 = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
				Shift_400 = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.84,
				},
			},
			State = {
				Hover = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.92,
				},
				Idle = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 1,
				},
				Press = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
			},
			Stroke = {
				Default = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.88,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.84,
				},
				Muted = {
					Color3 = Color3.fromRGB(208, 217, 251),
					Transparency = 0.92,
				},
			},
			Surface = {
				Surface_0 = {
					Color3 = Color3.fromRGB(18, 18, 21),
					Transparency = 0,
				},
				Surface_100 = {
					Color3 = Color3.fromRGB(25, 26, 31),
					Transparency = 0,
				},
				Surface_200 = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Surface_300 = {
					Color3 = Color3.fromRGB(39, 41, 48),
					Transparency = 0,
				},
			},
			System = {
				Alert = {
					Color3 = Color3.fromRGB(223, 40, 31),
					Transparency = 0,
				},
				Contrast = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Neutral = {
					Color3 = Color3.fromRGB(188, 190, 200),
					Transparency = 0,
				},
				Success = {
					Color3 = Color3.fromRGB(57, 197, 130),
					Transparency = 0,
				},
				Warning = {
					Color3 = Color3.fromRGB(242, 186, 42),
					Transparency = 0,
				},
			},
		},
		LetterSpacing = {
			Default = 0,
			Loose = 0.01,
			Tight = -0.01,
		},
		LightMode = {
			ActionAlert = {
				Background = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(217, 28, 21),
					Transparency = 0,
				},
			},
			ActionEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionLink = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionOverMedia = {
				Background = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionSoftEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0.7,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(0, 20, 92),
					Transparency = 0,
				},
			},
			ActionStandard = {
				Background = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionSubEmphasis = {
				Background = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			ActionSubtle = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(73, 77, 90),
					Transparency = 0,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			ActionUtility = {
				Background = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Border = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Foreground = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
			},
			Common = {
				Backdrop = {
					Color3 = Color3.fromRGB(10, 10, 14),
					Transparency = 0.5,
				},
				HeavyDivider = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.96,
				},
				NavigationBar = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
				Scrim = {
					Color3 = Color3.fromRGB(10, 10, 14),
					Transparency = 0.5,
				},
				Shadow = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 0.5,
				},
				Shimmer = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
			},
			Content = {
				Default = {
					Color3 = Color3.fromRGB(73, 77, 90),
					Transparency = 0,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Link = {
					Color3 = Color3.fromRGB(20, 70, 255),
					Transparency = 0,
				},
				Muted = {
					Color3 = Color3.fromRGB(106, 111, 129),
					Transparency = 0,
				},
			},
			None = {
				Color3 = Color3.fromRGB(0, 0, 0),
				Transparency = 1,
			},
			OverMedia = {
				OverMedia_0 = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0.08,
				},
				OverMedia_100 = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0.08,
				},
				OverMedia_200 = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0.08,
				},
				OverMedia_300 = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0.08,
				},
			},
			Selection = {
				End = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Start = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
			},
			Shift = {
				Shift_100 = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.96,
				},
				Shift_200 = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.92,
				},
				Shift_300 = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
				Shift_400 = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.84,
				},
			},
			State = {
				Hover = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.92,
				},
				Idle = {
					Color3 = Color3.fromRGB(0, 0, 0),
					Transparency = 1,
				},
				Press = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
			},
			Stroke = {
				Default = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.88,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.84,
				},
				Muted = {
					Color3 = Color3.fromRGB(27, 37, 75),
					Transparency = 0.92,
				},
			},
			Surface = {
				Surface_0 = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
				Surface_100 = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
				Surface_200 = {
					Color3 = Color3.fromRGB(255, 255, 255),
					Transparency = 0,
				},
				Surface_300 = {
					Color3 = Color3.fromRGB(247, 247, 248),
					Transparency = 0,
				},
			},
			System = {
				Alert = {
					Color3 = Color3.fromRGB(223, 40, 31),
					Transparency = 0,
				},
				Contrast = {
					Color3 = Color3.fromRGB(32, 34, 39),
					Transparency = 0,
				},
				Emphasis = {
					Color3 = Color3.fromRGB(51, 95, 255),
					Transparency = 0,
				},
				Neutral = {
					Color3 = Color3.fromRGB(73, 77, 90),
					Transparency = 0,
				},
				Success = {
					Color3 = Color3.fromRGB(57, 197, 130),
					Transparency = 0,
				},
				Warning = {
					Color3 = Color3.fromRGB(242, 186, 42),
					Transparency = 0,
				},
			},
		},
		LineHeight = {
			LineHeight_100 = 0.794,
			LineHeight_120 = 0.952,
			LineHeight_130 = 1.032,
			LineHeight_140 = 1.111,
		},
		Margin = {
			Large = 48 * scale,
			Medium = 24 * scale,
			None = 0,
			Small = 20 * scale,
		},
		Padding = {
			Large = 16 * scale,
			Medium = 12 * scale,
			None = 0,
			Small = 8 * scale,
			XLarge = 20 * scale,
			XSmall = 4 * scale,
			XXLarge = 24 * scale,
			XXSmall = 2 * scale,
		},
		Platform = {
			Base = 4 * scale,
			Rem = 8 * scale,
			Scale = 1 * scale,
		},
		Radius = {
			Circle = 9999,
			Large = 16 * scale,
			Medium = 8 * scale,
			None = 0,
			Small = 4 * scale,
			XSmall = 2 * scale,
		},
		Semantic = {
			Color = {
				Action = {
					Alert = {
						Background = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.88,
						},
						Border = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
						Content = {
							Color3 = Color3.fromRGB(217, 28, 21),
							Transparency = 0,
						},
					},
					Primary = {
						Background = {
							Color3 = Color3.fromRGB(32, 34, 39),
							Transparency = 0,
						},
						Border = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
						Content = {
							Color3 = Color3.fromRGB(247, 247, 248),
							Transparency = 0,
						},
					},
					PrimaryBrand = {
						Background = {
							Color3 = Color3.fromRGB(51, 95, 255),
							Transparency = 0,
						},
						Border = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
						Content = {
							Color3 = Color3.fromRGB(247, 247, 248),
							Transparency = 0,
						},
					},
					Secondary = {
						Background = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
						Border = {
							Color3 = Color3.fromRGB(73, 77, 90),
							Transparency = 0,
						},
						Content = {
							Color3 = Color3.fromRGB(32, 34, 39),
							Transparency = 0,
						},
					},
					Subtle = {
						Background = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
						Border = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
						Content = {
							Color3 = Color3.fromRGB(32, 34, 39),
							Transparency = 0,
						},
					},
				},
				Background = {
					Contrast = {
						Color3 = Color3.fromRGB(247, 247, 248),
						Transparency = 0,
					},
					Default = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0,
					},
					Muted = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0,
					},
					OnHover = {
						Color3 = Color3.fromRGB(27, 37, 75),
						Transparency = 0.92,
					},
					OnPress = {
						Color3 = Color3.fromRGB(27, 37, 75),
						Transparency = 0.88,
					},
				},
				BackgroundUi = {
					Contrast = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0.08,
					},
					Default = {
						Color3 = Color3.fromRGB(247, 247, 248),
						Transparency = 0,
					},
				},
				Common = {
					Alert = {
						Color3 = Color3.fromRGB(223, 40, 31),
						Transparency = 0,
					},
					Badge = {
						Color3 = Color3.fromRGB(32, 34, 39),
						Transparency = 0,
					},
					BadgeContent = {
						Color3 = Color3.fromRGB(247, 247, 248),
						Transparency = 0,
					},
					Divider = {
						Color3 = Color3.fromRGB(27, 37, 75),
						Transparency = 0.84,
					},
					DropShadow = {
						Color3 = Color3.fromRGB(0, 0, 0),
						Transparency = 0.5,
					},
					NavigationBar = {
						Color3 = Color3.fromRGB(255, 255, 255),
						Transparency = 0,
					},
					Offline = {
						Color3 = Color3.fromRGB(73, 77, 90),
						Transparency = 0,
					},
					Online = {
						Color3 = Color3.fromRGB(57, 197, 130),
						Transparency = 0,
					},
					Overlay = {
						Color3 = Color3.fromRGB(10, 10, 14),
						Transparency = 0.5,
					},
					Placeholder = {
						Color3 = Color3.fromRGB(27, 37, 75),
						Transparency = 0.88,
					},
					Success = {
						Color3 = Color3.fromRGB(57, 197, 130),
						Transparency = 0,
					},
				},
				Focus = {
					End = {
						Color3 = Color3.fromRGB(51, 95, 255),
						Transparency = 0,
					},
					Gradient = {
						Color3 = Color3.fromRGB(51, 95, 255),
						Transparency = 0,
					},
					Start = {
						Color3 = Color3.fromRGB(51, 95, 255),
						Transparency = 0,
					},
				},
				Icon = {
					Default = {
						Color3 = Color3.fromRGB(73, 77, 90),
						Transparency = 0,
					},
					Emphasis = {
						Color3 = Color3.fromRGB(32, 34, 39),
						Transparency = 0,
					},
					OnHover = {
						Color3 = Color3.fromRGB(32, 34, 39),
						Transparency = 0,
					},
				},
				State = {
					Darken = {
						Default = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
						Hover = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.92,
						},
						Pressed = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.88,
						},
					},
					Inverse = {
						Default = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
						Hover = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.92,
						},
						Pressed = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.88,
						},
					},
					Lighten = {
						Default = {
							Color3 = Color3.fromRGB(255, 255, 255),
							Transparency = 1,
						},
						Hover = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.92,
						},
						Pressed = {
							Color3 = Color3.fromRGB(208, 217, 251),
							Transparency = 0.88,
						},
					},
					Standard = {
						Default = {
							Color3 = Color3.fromRGB(0, 0, 0),
							Transparency = 1,
						},
						Hover = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.92,
						},
						Pressed = {
							Color3 = Color3.fromRGB(27, 37, 75),
							Transparency = 0.88,
						},
					},
				},
				Text = {
					Default = {
						Color3 = Color3.fromRGB(73, 77, 90),
						Transparency = 0,
					},
					Emphasis = {
						Color3 = Color3.fromRGB(32, 34, 39),
						Transparency = 0,
					},
					Inverse = {
						Color3 = Color3.fromRGB(213, 215, 221),
						Transparency = 0,
					},
					Link = {
						Color3 = Color3.fromRGB(20, 70, 255),
						Transparency = 0,
					},
					Muted = {
						Color3 = Color3.fromRGB(106, 111, 129),
						Transparency = 0,
					},
				},
				Ui = {
					Default = {
						Color3 = Color3.fromRGB(27, 37, 75),
						Transparency = 0.92,
					},
					Emphasis = {
						Color3 = Color3.fromRGB(27, 37, 75),
						Transparency = 0.84,
					},
					Muted = {
						Color3 = Color3.fromRGB(27, 37, 75),
						Transparency = 0.96,
					},
				},
			},
			Icon = {
				Size = {
					Large = 48 * scale,
					Medium = 36 * scale,
					Small = 16 * scale,
					XLarge = 96 * scale,
					XXLarge = 192 * scale,
				},
			},
			Offset = {
				Focus = {
					Inset = 0,
					Standard = 6 * scale,
				},
			},
			Opacity = {
				State = {
					Darken = {
						Hover = 0.88,
						Pressed = 0.8,
					},
					Lighten = {
						Hover = 0.88,
						Pressed = 0.8,
					},
				},
			},
			Radius = {
				Circle = 9999,
				Large = 12 * scale,
				Medium = 8 * scale,
				None = 0,
				Small = 4 * scale,
				XLarge = 16 * scale,
			},
			Stroke = {
				Focus = 3 * scale,
				Input = 1 * scale,
			},
			Typography = {
				Body = {
					Font = Enum.Font.BuilderSans,
					FontSize = 20.160 * scale,
					LetterSpacing = 0,
					LineHeight = 1.111,
				},
				CaptionBody = {
					Font = Enum.Font.BuilderSans,
					FontSize = 15.120 * scale,
					LetterSpacing = 0,
					LineHeight = 1.111,
				},
				CaptionHeader = {
					Font = Enum.Font.BuilderSansMedium,
					FontSize = 17.640 * scale,
					LetterSpacing = 0,
					LineHeight = 1.111,
				},
				Footer = {
					Font = Enum.Font.BuilderSansMedium,
					FontSize = 12.600 * scale,
					LetterSpacing = 0,
					LineHeight = 1.111,
				},
				Header = {
					Font = Enum.Font.BuilderSansBold,
					FontSize = 25.200 * scale,
					LetterSpacing = -0.01,
					LineHeight = 0.952,
				},
				Subheader = {
					Font = Enum.Font.BuilderSansBold,
					FontSize = 20.160 * scale,
					LetterSpacing = 0,
					LineHeight = 1.111,
				},
				Title = {
					Font = Enum.Font.BuilderSansBold,
					FontSize = 35.280 * scale,
					LetterSpacing = -0.01,
					LineHeight = 0.952,
				},
			},
		},
		Size = {
			Size_0 = 0,
			Size_50 = 2 * scale,
			Size_100 = 4 * scale,
			Size_150 = 6 * scale,
			Size_200 = 8 * scale,
			Size_250 = 10 * scale,
			Size_300 = 12 * scale,
			Size_350 = 14 * scale,
			Size_400 = 16 * scale,
			Size_500 = 20 * scale,
			Size_600 = 24 * scale,
			Size_700 = 28 * scale,
			Size_800 = 32 * scale,
			Size_900 = 36 * scale,
			Size_1000 = 40 * scale,
			Size_1100 = 44 * scale,
			Size_1200 = 48 * scale,
			Size_1300 = 52 * scale,
			Size_1400 = 56 * scale,
			Size_1500 = 60 * scale,
			Size_1600 = 64 * scale,
			Size_1700 = 68 * scale,
			Size_1800 = 72 * scale,
			Size_1900 = 76 * scale,
			Size_2000 = 80 * scale,
			Size_2100 = 84 * scale,
			Size_2200 = 88 * scale,
			Size_2300 = 92 * scale,
			Size_2400 = 96 * scale,
			Size_2500 = 100 * scale,
			Size_2600 = 104 * scale,
			Size_2700 = 108 * scale,
			Size_2800 = 112 * scale,
			Size_2900 = 116 * scale,
			Size_3000 = 120 * scale,
		},
		Stroke = {
			None = 0,
			Standard = 1 * scale,
			Thick = 1.500 * scale,
			Thicker = 3 * scale,
			Thin = 0.500 * scale,
		},
		Time = {
			Time_50 = 0.05,
			Time_100 = 0.1,
			Time_200 = 0.2,
			Time_300 = 0.3,
			Time_400 = 0.4,
			Time_500 = 0.5,
			Time_600 = 0.6,
			Time_700 = 0.7,
			Time_800 = 0.8,
			Time_900 = 0.9,
			Time_1000 = 1,
		},
		ToggleSize = {
			Large = 28 * scale,
			Medium = 24 * scale,
			Small = 20 * scale,
			XSmall = 16 * scale,
		},
		Typography = {
			BodyLarge = {
				Font = Enum.Font.BuilderSans,
				FontSize = 20.160 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
			BodyMedium = {
				Font = Enum.Font.BuilderSans,
				FontSize = 17.640 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
			BodySmall = {
				Font = Enum.Font.BuilderSans,
				FontSize = 15.120 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
			CaptionLarge = {
				Font = Enum.Font.BuilderSansMedium,
				FontSize = 17.640 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
			CaptionMedium = {
				Font = Enum.Font.BuilderSansMedium,
				FontSize = 15.120 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
			CaptionSmall = {
				Font = Enum.Font.BuilderSansMedium,
				FontSize = 12.600 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
			DisplayLarge = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 100.800 * scale,
				LetterSpacing = -0.01,
				LineHeight = 0.952,
			},
			DisplayMedium = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 70.560 * scale,
				LetterSpacing = -0.01,
				LineHeight = 0.952,
			},
			DisplaySmall = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 50.400 * scale,
				LetterSpacing = -0.01,
				LineHeight = 0.952,
			},
			HeadingLarge = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 35.280 * scale,
				LetterSpacing = -0.01,
				LineHeight = 0.952,
			},
			HeadingMedium = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 30.240 * scale,
				LetterSpacing = -0.01,
				LineHeight = 0.952,
			},
			HeadingSmall = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 25.200 * scale,
				LetterSpacing = -0.01,
				LineHeight = 0.952,
			},
			LabelLarge = {
				Font = Enum.Font.BuilderSansMedium,
				FontSize = 20.160 * scale,
				LetterSpacing = 0,
				LineHeight = 0.794,
			},
			LabelMedium = {
				Font = Enum.Font.BuilderSansMedium,
				FontSize = 17.640 * scale,
				LetterSpacing = 0,
				LineHeight = 0.794,
			},
			LabelSmall = {
				Font = Enum.Font.BuilderSansMedium,
				FontSize = 15.120 * scale,
				LetterSpacing = 0,
				LineHeight = 0.794,
			},
			TitleLarge = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 20.160 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
			TitleMedium = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 17.640 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
			TitleSmall = {
				Font = Enum.Font.BuilderSansBold,
				FontSize = 15.120 * scale,
				LetterSpacing = 0,
				LineHeight = 1.111,
			},
		},
	}
end
