--[[
 * Copyright (c) GraphQL Contributors
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
]]
-- ROBLOX upstream: https://github.com/graphql/graphql-js/blob/00d4efea7f5b44088356798afff0317880605f4d/src/jsutils/mapValue.js
--[[
 * Creates an object map with the same keys as `map` and values generated by
 * running each value of `map` thru `fn`.
 ]]
local ObjMapModule = require(script.Parent.ObjMap)
type ObjMap<T> = ObjMapModule.ObjMap<T>

local function mapValue<T, V>(map: ObjMap<T>, fn: (value: T, key: string) -> V): ObjMap<V>
	local result = {}
	for key, value in pairs(map) do
		result[key] = fn(value, key)
	end
	return result
end

return {
	mapValue = mapValue,
}
