--!strict
--!nolint LocalUnused
--!nolint ImportUnused
--# selene: allow(empty_if, if_same_then_else, manual_table_clone, unused_variable)
-- This file was @autogenerated by protoc-gen-luau
local proto = require(script.Parent.Parent.Parent.Parent.Parent.proto)
local typeRegistry = require(script.Parent.Parent.Parent.Parent.Parent.proto.typeRegistry)

type _Messages = {
	BadgeData: _BadgeDataMessage,
}
local messages: _Messages = {} :: _Messages

local _google_protobuf_timestamp = require(script.Parent.Parent.Parent.Parent.Parent.google.protobuf.timestamp)

type _BadgeDataImpl = {
	__index: _BadgeDataImpl,
	new: (fields: _BadgeDataPartialFields?) -> BadgeData,
	encode: (self: BadgeData) -> buffer,
	decode: (input: buffer) -> BadgeData,
	jsonEncode: (self: BadgeData) -> { [string]: any },
	jsonDecode: (input: { [string]: any }) -> BadgeData,
	descriptor: proto.Descriptor,
}

type _BadgeDataFields = {
	id: number,
	display_name: string,
	display_icon_image_id: number,
	display_description: string,
	total_awarded_count: number,
	past_day_awarded_count: number,
	rarity_percentage: number,
	badge_type_label: string,
	created_time: _google_protobuf_timestamp.Timestamp?,
	updated_time: _google_protobuf_timestamp.Timestamp?,
	is_earned_by_user: boolean,
}

type _BadgeDataPartialFields = {
	id: number?,
	display_name: string?,
	display_icon_image_id: number?,
	display_description: string?,
	total_awarded_count: number?,
	past_day_awarded_count: number?,
	rarity_percentage: number?,
	badge_type_label: string?,
	created_time: _google_protobuf_timestamp.Timestamp?,
	updated_time: _google_protobuf_timestamp.Timestamp?,
	is_earned_by_user: boolean?,
}

export type BadgeData = typeof(setmetatable({} :: _BadgeDataFields, {} :: _BadgeDataImpl))
type _BadgeDataMessage = proto.Message<BadgeData, _BadgeDataPartialFields>

do
	local _BadgeDataImpl = {}
	_BadgeDataImpl.__index = _BadgeDataImpl

	function _BadgeDataImpl.new(data: _BadgeDataPartialFields?): BadgeData
		return setmetatable({
			id = if data == nil or data.id == nil then 0 else data.id,
			display_name = if data == nil or data.display_name == nil then "" else data.display_name,
			display_icon_image_id = if data == nil or data.display_icon_image_id == nil
				then 0
				else data.display_icon_image_id,
			display_description = if data == nil or data.display_description == nil
				then ""
				else data.display_description,
			total_awarded_count = if data == nil or data.total_awarded_count == nil
				then 0
				else data.total_awarded_count,
			past_day_awarded_count = if data == nil or data.past_day_awarded_count == nil
				then 0
				else data.past_day_awarded_count,
			rarity_percentage = if data == nil or data.rarity_percentage == nil then 0 else data.rarity_percentage,
			badge_type_label = if data == nil or data.badge_type_label == nil then "" else data.badge_type_label,
			created_time = if data == nil or data.created_time == nil then nil else data.created_time,
			updated_time = if data == nil or data.updated_time == nil then nil else data.updated_time,
			is_earned_by_user = if data == nil or data.is_earned_by_user == nil then false else data.is_earned_by_user,
		}, _BadgeDataImpl :: _BadgeDataImpl)
	end

	function _BadgeDataImpl.encode(self: BadgeData): buffer
		local output = buffer.create(0)
		local cursor = 0

		if self.id ~= nil and self.id ~= 0 then
			output, cursor = proto.writeTag(output, cursor, 1, proto.wireTypes.varint)
			output, cursor = proto.writeVarInt(output, cursor, self.id)
		end

		if self.display_name ~= nil and self.display_name ~= "" then
			output, cursor = proto.writeTag(output, cursor, 2, proto.wireTypes.lengthDelimited)
			output, cursor = proto.writeString(output, cursor, self.display_name)
		end

		if self.display_icon_image_id ~= nil and self.display_icon_image_id ~= 0 then
			output, cursor = proto.writeTag(output, cursor, 3, proto.wireTypes.varint)
			output, cursor = proto.writeVarInt(output, cursor, self.display_icon_image_id)
		end

		if self.display_description ~= nil and self.display_description ~= "" then
			output, cursor = proto.writeTag(output, cursor, 4, proto.wireTypes.lengthDelimited)
			output, cursor = proto.writeString(output, cursor, self.display_description)
		end

		if self.total_awarded_count ~= nil and self.total_awarded_count ~= 0 then
			output, cursor = proto.writeTag(output, cursor, 5, proto.wireTypes.varint)
			output, cursor = proto.writeVarInt(output, cursor, self.total_awarded_count)
		end

		if self.past_day_awarded_count ~= nil and self.past_day_awarded_count ~= 0 then
			output, cursor = proto.writeTag(output, cursor, 6, proto.wireTypes.varint)
			output, cursor = proto.writeVarInt(output, cursor, self.past_day_awarded_count)
		end

		if self.rarity_percentage ~= nil and self.rarity_percentage ~= 0 then
			output, cursor = proto.writeTag(output, cursor, 7, proto.wireTypes.i64)
			output, cursor = proto.writeDouble(output, cursor, self.rarity_percentage)
		end

		if self.badge_type_label ~= nil and self.badge_type_label ~= "" then
			output, cursor = proto.writeTag(output, cursor, 8, proto.wireTypes.lengthDelimited)
			output, cursor = proto.writeString(output, cursor, self.badge_type_label)
		end

		if self.created_time ~= nil then
			local encoded = self.created_time:encode()
			output, cursor = proto.writeTag(output, cursor, 9, proto.wireTypes.lengthDelimited)
			output, cursor = proto.writeBuffer(output, cursor, encoded, buffer.len(encoded))
		end

		if self.updated_time ~= nil then
			local encoded = self.updated_time:encode()
			output, cursor = proto.writeTag(output, cursor, 10, proto.wireTypes.lengthDelimited)
			output, cursor = proto.writeBuffer(output, cursor, encoded, buffer.len(encoded))
		end

		if self.is_earned_by_user then
			output, cursor = proto.writeTag(output, cursor, 11, proto.wireTypes.varint)
			output, cursor = proto.writeVarInt(output, cursor, if self.is_earned_by_user then 1 else 0)
		end

		local shrunkBuffer = buffer.create(cursor)
		buffer.copy(shrunkBuffer, 0, output, 0, cursor)
		return shrunkBuffer
	end

	function _BadgeDataImpl.decode(input: buffer): BadgeData
		local self = _BadgeDataImpl.new()
		local cursor = 0

		while cursor < buffer.len(input) do
			local field, wireType
			field, wireType, cursor = proto.readTag(input, cursor)

			if wireType == proto.wireTypes.varint then
				if field == 1 then
					local value
					value, cursor = proto.readVarIntI64(input, cursor)
					self.id = value
					continue
				elseif field == 3 then
					local value
					value, cursor = proto.readVarIntI64(input, cursor)
					self.display_icon_image_id = value
					continue
				elseif field == 5 then
					local value
					value, cursor = proto.readVarIntI64(input, cursor)
					self.total_awarded_count = value
					continue
				elseif field == 6 then
					local value
					value, cursor = proto.readVarIntI64(input, cursor)
					self.past_day_awarded_count = value
					continue
				elseif field == 11 then
					local value
					value, cursor = proto.readVarInt(input, cursor)
					self.is_earned_by_user = value ~= 0
					continue
				end

				local _
				_, cursor = proto.readVarInt(input, cursor)
			elseif wireType == proto.wireTypes.lengthDelimited then
				if field == 2 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.display_name = buffer.tostring(value)
					continue
				elseif field == 4 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.display_description = buffer.tostring(value)
					continue
				elseif field == 8 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.badge_type_label = buffer.tostring(value)
					continue
				elseif field == 9 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.created_time = _google_protobuf_timestamp.Timestamp.decode(value)
					continue
				elseif field == 10 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.updated_time = _google_protobuf_timestamp.Timestamp.decode(value)
					continue
				end

				local length
				length, cursor = proto.readVarInt(input, cursor)

				cursor += length
			elseif wireType == proto.wireTypes.i32 then
				-- No fields

				local _
				_, cursor = proto.readFixed32(input, cursor)
			elseif wireType == proto.wireTypes.i64 then
				if field == 7 then
					local value
					value, cursor = proto.readDouble(input, cursor)
					self.rarity_percentage = value
					continue
				end

				local _
				_, cursor = proto.readFixed64(input, cursor)
			else
				error("Unsupported wire type: " .. wireType)
			end
		end

		return self
	end

	function _BadgeDataImpl.jsonEncode(self: BadgeData): any
		local output = {}

		if self.id ~= nil and self.id ~= 0 then
			output.id = self.id
		end

		if self.display_name ~= nil and self.display_name ~= "" then
			output.displayName = self.display_name
		end

		if self.display_icon_image_id ~= nil and self.display_icon_image_id ~= 0 then
			output.displayIconImageId = self.display_icon_image_id
		end

		if self.display_description ~= nil and self.display_description ~= "" then
			output.displayDescription = self.display_description
		end

		if self.total_awarded_count ~= nil and self.total_awarded_count ~= 0 then
			output.totalAwardedCount = self.total_awarded_count
		end

		if self.past_day_awarded_count ~= nil and self.past_day_awarded_count ~= 0 then
			output.pastDayAwardedCount = self.past_day_awarded_count
		end

		if self.rarity_percentage ~= nil and self.rarity_percentage ~= 0 then
			output.rarityPercentage = proto.json.serializeNumber(self.rarity_percentage)
		end

		if self.badge_type_label ~= nil and self.badge_type_label ~= "" then
			output.badgeTypeLabel = self.badge_type_label
		end

		if self.created_time ~= nil then
			output.createdTime = self.created_time:jsonEncode()
		end

		if self.updated_time ~= nil then
			output.updatedTime = self.updated_time:jsonEncode()
		end

		if self.is_earned_by_user then
			output.isEarnedByUser = self.is_earned_by_user
		end

		return output
	end

	function _BadgeDataImpl.jsonDecode(input: { [string]: any }): BadgeData
		local self = _BadgeDataImpl.new()

		if input.id ~= nil then
			self.id = input.id
		end

		if input.display_name ~= nil then
			self.display_name = input.display_name
		end

		if input.displayName ~= nil then
			self.display_name = input.displayName
		end

		if input.display_icon_image_id ~= nil then
			self.display_icon_image_id = input.display_icon_image_id
		end

		if input.displayIconImageId ~= nil then
			self.display_icon_image_id = input.displayIconImageId
		end

		if input.display_description ~= nil then
			self.display_description = input.display_description
		end

		if input.displayDescription ~= nil then
			self.display_description = input.displayDescription
		end

		if input.total_awarded_count ~= nil then
			self.total_awarded_count = input.total_awarded_count
		end

		if input.totalAwardedCount ~= nil then
			self.total_awarded_count = input.totalAwardedCount
		end

		if input.past_day_awarded_count ~= nil then
			self.past_day_awarded_count = input.past_day_awarded_count
		end

		if input.pastDayAwardedCount ~= nil then
			self.past_day_awarded_count = input.pastDayAwardedCount
		end

		if input.rarity_percentage ~= nil then
			self.rarity_percentage = proto.json.deserializeNumber(input.rarity_percentage)
		end

		if input.rarityPercentage ~= nil then
			self.rarity_percentage = proto.json.deserializeNumber(input.rarityPercentage)
		end

		if input.badge_type_label ~= nil then
			self.badge_type_label = input.badge_type_label
		end

		if input.badgeTypeLabel ~= nil then
			self.badge_type_label = input.badgeTypeLabel
		end

		if input.created_time ~= nil then
			self.created_time = _google_protobuf_timestamp.Timestamp.jsonDecode(input.created_time)
		end

		if input.createdTime ~= nil then
			self.created_time = _google_protobuf_timestamp.Timestamp.jsonDecode(input.createdTime)
		end

		if input.updated_time ~= nil then
			self.updated_time = _google_protobuf_timestamp.Timestamp.jsonDecode(input.updated_time)
		end

		if input.updatedTime ~= nil then
			self.updated_time = _google_protobuf_timestamp.Timestamp.jsonDecode(input.updatedTime)
		end

		if input.is_earned_by_user ~= nil then
			self.is_earned_by_user = input.is_earned_by_user
		end

		if input.isEarnedByUser ~= nil then
			self.is_earned_by_user = input.isEarnedByUser
		end

		return self
	end

	_BadgeDataImpl.descriptor = {
		name = "BadgeData",
		fullName = "roblox.apppageplatform.shared.v1beta1.BadgeData",
	}

	messages.BadgeData = _BadgeDataImpl :: any -- Luau: Not sure why this intersection fails.

	typeRegistry.default:register(messages.BadgeData)
end

return {
	BadgeData = messages.BadgeData,
}
