--!nonstrict
local ContextActionService = game:GetService("ContextActionService")
local CoreGui = game:GetService("CoreGui")
local CorePackages = game:GetService("CorePackages")
local GuiService = game:GetService("GuiService")
local RobloxGui = CoreGui:WaitForChild("RobloxGui")

local Roact = require(CorePackages.Packages.Roact)
local Promise = require(CorePackages.Packages.Promise)

local CoreScriptsRootProvider = require(CorePackages.Workspace.Packages.CoreScriptsRoactCommon).CoreScriptsRootProvider
local PlayerListPackage = require(CorePackages.Workspace.Packages.PlayerList)

local BlockingAnalytics = require(script.Parent.Analytics.BlockingAnalytics)
local BlockingModalScreen = require(script.Parent.Components.Blocking.BlockingModalScreen)

local FFlagAddNewPlayerListMobileFocusNav = PlayerListPackage.Flags.FFlagAddNewPlayerListMobileFocusNav

local PAGE_CONTEXT_NAME = "BlockingModalScreen"

local handle

local unmount = function()
	if handle ~= nil then
		Roact.unmount(handle)
		handle = nil
		ContextActionService:UnbindCoreAction(PAGE_CONTEXT_NAME)
	end
end


return function(player, analytics, source, config)
	return Promise.new(function(resolve)
		local blockingAnalytics = analytics or BlockingAnalytics.new()
		blockingAnalytics:action("SettingsHub", "blockUserButtonClick", {
			blockeeUserId = player.UserId,
			source = source,
		})

		unmount()

		local closeModal = function()
			unmount()
			resolve()
			if FFlagAddNewPlayerListMobileFocusNav then
				if config and config.onBlockingModalClose then
					config.onBlockingModalClose()
				end
			else
				if FFlagAddNewPlayerListMobileFocusNav then
					GuiService.SelectedCoreObject = nil
				end
			end
		end

		local blockingScreen = Roact.createElement(BlockingModalScreen, {
			player = player,
			closeModal = closeModal,
			analytics = blockingAnalytics,
			source = source,
			onBlockingSuccess = config and config.onBlockingSuccess or nil
		})

		local coreScriptsRootProvider = Roact.createElement(CoreScriptsRootProvider, {}, {
			BlockingModalScreen = blockingScreen,
		})
		handle = Roact.mount(coreScriptsRootProvider, RobloxGui, "BlockingContainer")
		ContextActionService:BindCoreAction(
			PAGE_CONTEXT_NAME,
			closeModal,
			false,
			Enum.KeyCode.ButtonB,
			Enum.KeyCode.Escape
		)
	end)
end
