--[[
	BrickColorConstants

	BrickColor palettes extracted from C++ implementation in Platform\UIComponents\src\RobloxCustomWidgets.cpp
	Used by BrickColorPicker for hexagonal grid layout.
	
	BrickColors are pre-constructed for performance and reliability.
]]

local createBrickColorsFromIds = require(script.Parent.createBrickColorsFromIds)

local BRICK_COLOR_ID_PALETTES = {
	MAIN = {
		141,
		301,
		107,
		26,
		1012,
		303,
		1011,
		304,
		28,
		1018,
		302,
		305,
		306,
		307,
		308,
		1021,
		309,
		310,
		1019,
		135,
		102,
		23,
		1010,
		312,
		313,
		37,
		1022,
		1020,
		1027,
		311,
		315,
		1023,
		1031,
		316,
		151,
		317,
		318,
		319,
		1024,
		314,
		1013,
		1006,
		321,
		322,
		104,
		1008,
		119,
		323,
		324,
		325,
		320,
		11,
		1026,
		1016,
		1032,
		1015,
		327,
		1005,
		1009,
		29,
		328,
		1028,
		208,
		45,
		329,
		330,
		331,
		1004,
		21,
		332,
		333,
		24,
		334,
		226,
		1029,
		335,
		336,
		342,
		343,
		338,
		1007,
		339,
		133,
		106,
		340,
		341,
		1001,
		1,
		9,
		1025,
		337,
		344,
		345,
		1014,
		105,
		346,
		347,
		348,
		349,
		1030,
		125,
		101,
		350,
		192,
		351,
		352,
		353,
		354,
		1002,
		5,
		18,
		217,
		355,
		356,
		153,
		357,
		358,
		359,
		360,
		38,
		361,
		362,
		199,
		194,
		363,
		364,
		365,
		1003,
	},
	BOTTOM = { 199, 194, 1002, 325, 348, 26, 302, 311, 320, 335, 1001, 1 },
}

-- Pre-construct BrickColors for performance and reliability
local BRICK_COLOR_PALETTES = {
	MAIN = createBrickColorsFromIds(BRICK_COLOR_ID_PALETTES.MAIN),
	BOTTOM = createBrickColorsFromIds(BRICK_COLOR_ID_PALETTES.BOTTOM),
}

return BRICK_COLOR_PALETTES
