--!strict
--!nolint LocalUnused
--!nolint ImportUnused
--# selene: allow(empty_if, if_same_then_else, manual_table_clone, unused_variable)
-- This file was @autogenerated by protoc-gen-luau
local proto = require(script.Parent.Parent.Parent.proto)
local typeRegistry = require(script.Parent.Parent.Parent.proto.typeRegistry)

type _Messages = {
	Struct: _StructMessage,
	Struct_FieldsEntry: _Struct_FieldsEntryMessage,
	Value: _ValueMessage,
	ListValue: _ListValueMessage,
	NullValue: _NullValueMessage,
}
local messages: _Messages = {} :: _Messages

type _StructImpl = {
	__index: _StructImpl,
	new: (fields: _StructPartialFields?) -> Struct,
	encode: (self: Struct) -> buffer,
	decode: (input: buffer) -> Struct,
	jsonEncode: (self: Struct) -> { [string]: any },
	jsonDecode: (input: { [string]: any }) -> Struct,
	descriptor: proto.Descriptor,
}

type _StructFields = {
	fields: { [string]: Value },
}

type _StructPartialFields = {
	fields: { [string]: Value }?,
}

export type Struct = typeof(setmetatable({} :: _StructFields, {} :: _StructImpl))
type _StructMessage = proto.Message<Struct, _StructPartialFields> & proto.CustomJson<Struct, { [string]: any }>

type _Struct_FieldsEntryImpl = {
	__index: _Struct_FieldsEntryImpl,
	new: (fields: _Struct_FieldsEntryPartialFields?) -> Struct_FieldsEntry,
	encode: (self: Struct_FieldsEntry) -> buffer,
	decode: (input: buffer) -> Struct_FieldsEntry,
	jsonEncode: (self: Struct_FieldsEntry) -> { [string]: any },
	jsonDecode: (input: { [string]: any }) -> Struct_FieldsEntry,
	descriptor: proto.Descriptor,
}

type _Struct_FieldsEntryFields = {
	key: string,
	value: Value?,
}

type _Struct_FieldsEntryPartialFields = {
	key: string?,
	value: Value?,
}

export type Struct_FieldsEntry = typeof(setmetatable({} :: _Struct_FieldsEntryFields, {} :: _Struct_FieldsEntryImpl))
type _Struct_FieldsEntryMessage = proto.Message<Struct_FieldsEntry, _Struct_FieldsEntryPartialFields>

type _ValueImpl = {
	__index: _ValueImpl,
	new: (fields: _ValuePartialFields?) -> Value,
	encode: (self: Value) -> buffer,
	decode: (input: buffer) -> Value,
	jsonEncode: (self: Value) -> any,
	jsonDecode: (input: any) -> Value,
	descriptor: proto.Descriptor,
}

type _ValueFields = {
	kind: (
		{ type: "null_value", value: NullValue }
		| { type: "number_value", value: number }
		| { type: "string_value", value: string }
		| { type: "bool_value", value: boolean }
		| { type: "struct_value", value: Struct }
		| { type: "list_value", value: ListValue }
	)?,
}

type _ValuePartialFields = {
	kind: (
		{ type: "null_value", value: NullValue }
		| { type: "number_value", value: number }
		| { type: "string_value", value: string }
		| { type: "bool_value", value: boolean }
		| { type: "struct_value", value: Struct }
		| { type: "list_value", value: ListValue }
	)?,
}

export type Value = typeof(setmetatable({} :: _ValueFields, {} :: _ValueImpl))
type _ValueMessage = proto.Message<Value, _ValuePartialFields> & proto.CustomJson<Value, any>

type _ListValueImpl = {
	__index: _ListValueImpl,
	new: (fields: _ListValuePartialFields?) -> ListValue,
	encode: (self: ListValue) -> buffer,
	decode: (input: buffer) -> ListValue,
	jsonEncode: (self: ListValue) -> { any },
	jsonDecode: (input: { any }) -> ListValue,
	descriptor: proto.Descriptor,
}

type _ListValueFields = {
	values: { Value },
}

type _ListValuePartialFields = {
	values: { Value }?,
}

export type ListValue = typeof(setmetatable({} :: _ListValueFields, {} :: _ListValueImpl))
type _ListValueMessage = proto.Message<ListValue, _ListValuePartialFields> & proto.CustomJson<ListValue, { any }>

type _NullValueMessage = proto.Enum<NullValue>
export type NullValue = "NULL_VALUE" | number -- Unknown

do
	local _StructImpl = {}
	_StructImpl.__index = _StructImpl

	function _StructImpl.new(data: _StructPartialFields?): Struct
		return setmetatable({
			fields = if data == nil or data.fields == nil then {} else data.fields,
		}, _StructImpl :: _StructImpl)
	end

	function _StructImpl.encode(self: Struct): buffer
		local output = buffer.create(0)
		local cursor = 0

		if self.fields ~= nil and next(self.fields) ~= nil then
			for key, value in self.fields do
				local mapBuffer = buffer.create(0)
				local mapCursor = 0
				mapBuffer, mapCursor = proto.writeTag(mapBuffer, mapCursor, 1, proto.wireTypes.lengthDelimited)
				mapBuffer, mapCursor = proto.writeString(mapBuffer, mapCursor, key)
				local encoded = value:encode()
				mapBuffer, mapCursor = proto.writeTag(mapBuffer, mapCursor, 2, proto.wireTypes.lengthDelimited)
				mapBuffer, mapCursor = proto.writeBuffer(mapBuffer, mapCursor, encoded, buffer.len(encoded))
				output, cursor = proto.writeTag(output, cursor, 1, proto.wireTypes.lengthDelimited)
				output, cursor = proto.writeBuffer(output, cursor, mapBuffer, mapCursor)
			end
		end

		local shrunkBuffer = buffer.create(cursor)
		buffer.copy(shrunkBuffer, 0, output, 0, cursor)
		return shrunkBuffer
	end

	function _StructImpl.decode(input: buffer): Struct
		local self = _StructImpl.new()
		local cursor = 0

		while cursor < buffer.len(input) do
			local field, wireType
			field, wireType, cursor = proto.readTag(input, cursor)

			if wireType == proto.wireTypes.varint then
				-- No fields

				local _
				_, cursor = proto.readVarInt(input, cursor)
			elseif wireType == proto.wireTypes.lengthDelimited then
				if field == 1 then
					local value
					value, cursor = proto.readBuffer(input, cursor)

					local mapEntry = messages.Struct_FieldsEntry.decode(value)

					local keyDefault = ""
					local valueDefault = messages.Value.new()

					self.fields[mapEntry.key or keyDefault] = mapEntry.value or valueDefault

					continue
				end

				local length
				length, cursor = proto.readVarInt(input, cursor)

				cursor += length
			elseif wireType == proto.wireTypes.i32 then
				-- No fields

				local _
				_, cursor = proto.readFixed32(input, cursor)
			elseif wireType == proto.wireTypes.i64 then
				-- No fields

				local _
				_, cursor = proto.readFixed64(input, cursor)
			else
				error("Unsupported wire type: " .. wireType)
			end
		end

		return self
	end

	function _StructImpl.jsonEncode(struct: Struct): { [string]: any }
		local serialized = {}

		for key, value in struct.fields do
			serialized[key] = messages.Value.jsonEncode(value)
		end

		return serialized
	end

	function _StructImpl.jsonDecode(input: { [string]: any }): Struct
		local fields = {}

		for key, serializedValue in input do
			fields[key] = messages.Value.jsonDecode(serializedValue)
		end

		return _StructImpl.new({
			fields = fields,
		})
	end

	_StructImpl.descriptor = {
		name = "Struct",
		fullName = "google.protobuf.Struct",
	}

	messages.Struct = _StructImpl :: any -- Luau: Not sure why this intersection fails.

	typeRegistry.default:register(messages.Struct)
end

do
	local _Struct_FieldsEntryImpl = {}
	_Struct_FieldsEntryImpl.__index = _Struct_FieldsEntryImpl

	function _Struct_FieldsEntryImpl.new(data: _Struct_FieldsEntryPartialFields?): Struct_FieldsEntry
		return setmetatable({
			key = if data == nil or data.key == nil then "" else data.key,
			value = if data == nil or data.value == nil then nil else data.value,
		}, _Struct_FieldsEntryImpl :: _Struct_FieldsEntryImpl)
	end

	function _Struct_FieldsEntryImpl.encode(self: Struct_FieldsEntry): buffer
		local output = buffer.create(0)
		local cursor = 0

		if self.key ~= nil and self.key ~= "" then
			output, cursor = proto.writeTag(output, cursor, 1, proto.wireTypes.lengthDelimited)
			output, cursor = proto.writeString(output, cursor, self.key)
		end

		if self.value ~= nil then
			local encoded = self.value:encode()
			output, cursor = proto.writeTag(output, cursor, 2, proto.wireTypes.lengthDelimited)
			output, cursor = proto.writeBuffer(output, cursor, encoded, buffer.len(encoded))
		end

		local shrunkBuffer = buffer.create(cursor)
		buffer.copy(shrunkBuffer, 0, output, 0, cursor)
		return shrunkBuffer
	end

	function _Struct_FieldsEntryImpl.decode(input: buffer): Struct_FieldsEntry
		local self = _Struct_FieldsEntryImpl.new()
		local cursor = 0

		while cursor < buffer.len(input) do
			local field, wireType
			field, wireType, cursor = proto.readTag(input, cursor)

			if wireType == proto.wireTypes.varint then
				-- No fields

				local _
				_, cursor = proto.readVarInt(input, cursor)
			elseif wireType == proto.wireTypes.lengthDelimited then
				if field == 1 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.key = buffer.tostring(value)
					continue
				elseif field == 2 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.value = messages.Value.decode(value)
					continue
				end

				local length
				length, cursor = proto.readVarInt(input, cursor)

				cursor += length
			elseif wireType == proto.wireTypes.i32 then
				-- No fields

				local _
				_, cursor = proto.readFixed32(input, cursor)
			elseif wireType == proto.wireTypes.i64 then
				-- No fields

				local _
				_, cursor = proto.readFixed64(input, cursor)
			else
				error("Unsupported wire type: " .. wireType)
			end
		end

		return self
	end

	function _Struct_FieldsEntryImpl.jsonEncode(self: Struct_FieldsEntry): any
		local output = {}

		if self.key ~= nil and self.key ~= "" then
			output.key = self.key
		end

		if self.value ~= nil then
			output.value = self.value:jsonEncode()
		end

		return output
	end

	function _Struct_FieldsEntryImpl.jsonDecode(input: { [string]: any }): Struct_FieldsEntry
		local self = _Struct_FieldsEntryImpl.new()

		if input.key ~= nil then
			self.key = input.key
		end

		if input.value ~= nil then
			self.value = messages.Value.jsonDecode(input.value)
		end

		return self
	end

	_Struct_FieldsEntryImpl.descriptor = {
		name = "Struct_FieldsEntry",
		fullName = "google.protobuf.FieldsEntry",
	}

	messages.Struct_FieldsEntry = _Struct_FieldsEntryImpl :: any -- Luau: Not sure why this intersection fails.

	typeRegistry.default:register(messages.Struct_FieldsEntry)
end

do
	local _ValueImpl = {}
	_ValueImpl.__index = _ValueImpl

	function _ValueImpl.new(data: _ValuePartialFields?): Value
		return setmetatable({
			kind = if data == nil or data.kind == nil then nil else data.kind,
		}, _ValueImpl :: _ValueImpl)
	end

	function _ValueImpl.encode(self: Value): buffer
		local output = buffer.create(0)
		local cursor = 0

		if self.kind ~= nil then
			if self.kind.type == "null_value" then
				output, cursor = proto.writeTag(output, cursor, 1, proto.wireTypes.varint)
				output, cursor = proto.writeVarInt(output, cursor, messages.NullValue.toNumber(self.kind.value :: any))
			elseif self.kind.type == "number_value" then
				output, cursor = proto.writeTag(output, cursor, 2, proto.wireTypes.i64)
				output, cursor = proto.writeDouble(output, cursor, self.kind.value)
			elseif self.kind.type == "string_value" then
				output, cursor = proto.writeTag(output, cursor, 3, proto.wireTypes.lengthDelimited)
				output, cursor = proto.writeString(output, cursor, self.kind.value)
			elseif self.kind.type == "bool_value" then
				output, cursor = proto.writeTag(output, cursor, 4, proto.wireTypes.varint)
				output, cursor = proto.writeVarInt(output, cursor, if self.kind.value then 1 else 0)
			elseif self.kind.type == "struct_value" then
				local encoded = self.kind.value:encode()
				output, cursor = proto.writeTag(output, cursor, 5, proto.wireTypes.lengthDelimited)
				output, cursor = proto.writeBuffer(output, cursor, encoded, buffer.len(encoded))
			elseif self.kind.type == "list_value" then
				local encoded = self.kind.value:encode()
				output, cursor = proto.writeTag(output, cursor, 6, proto.wireTypes.lengthDelimited)
				output, cursor = proto.writeBuffer(output, cursor, encoded, buffer.len(encoded))
			end
		end

		local shrunkBuffer = buffer.create(cursor)
		buffer.copy(shrunkBuffer, 0, output, 0, cursor)
		return shrunkBuffer
	end

	function _ValueImpl.decode(input: buffer): Value
		local self = _ValueImpl.new()
		local cursor = 0

		while cursor < buffer.len(input) do
			local field, wireType
			field, wireType, cursor = proto.readTag(input, cursor)

			if wireType == proto.wireTypes.varint then
				if field == 1 then
					local value
					value, cursor = proto.readVarIntI32(input, cursor)
					self.kind = {
						type = "null_value",
						value = (messages.NullValue.fromNumber(value) or value) :: any --[[ Luau: Enums are a string intersection which Luau is quick to dismantle ]],
					}
					continue
				elseif field == 4 then
					local value
					value, cursor = proto.readVarInt(input, cursor)
					self.kind = { type = "bool_value", value = value ~= 0 }
					continue
				end

				local _
				_, cursor = proto.readVarInt(input, cursor)
			elseif wireType == proto.wireTypes.lengthDelimited then
				if field == 3 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.kind = { type = "string_value", value = buffer.tostring(value) }
					continue
				elseif field == 5 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.kind = { type = "struct_value", value = messages.Struct.decode(value) }
					continue
				elseif field == 6 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					self.kind = { type = "list_value", value = messages.ListValue.decode(value) }
					continue
				end

				local length
				length, cursor = proto.readVarInt(input, cursor)

				cursor += length
			elseif wireType == proto.wireTypes.i32 then
				-- No fields

				local _
				_, cursor = proto.readFixed32(input, cursor)
			elseif wireType == proto.wireTypes.i64 then
				if field == 2 then
					local value
					value, cursor = proto.readDouble(input, cursor)
					self.kind = { type = "number_value", value = value }
					continue
				end

				local _
				_, cursor = proto.readFixed64(input, cursor)
			else
				error("Unsupported wire type: " .. wireType)
			end
		end

		return self
	end

	function _ValueImpl.jsonEncode(input: Value): any
		local kind = input.kind

		if kind == nil or kind.type == "null_value" then
			return nil
		elseif kind.type == "number_value" or kind.type == "string_value" or kind.type == "bool_value" then
			return kind.value
		elseif kind.type == "list_value" then
			return messages.ListValue.jsonEncode(kind.value)
		elseif kind.type == "struct_value" then
			return messages.Struct.jsonEncode(kind.value)
		else
			local exhaustiveMatch: never = kind.type
			return exhaustiveMatch
		end
	end

	function _ValueImpl.jsonDecode(input: any): Value
		if input == nil then
			return _ValueImpl.new({ kind = { type = "null_value", value = "NULL_VALUE" } })
		elseif typeof(input) == "number" then
			return _ValueImpl.new({ kind = { type = "number_value", value = input } })
		elseif typeof(input) == "string" then
			return _ValueImpl.new({ kind = { type = "string_value", value = input } })
		elseif typeof(input) == "boolean" then
			return _ValueImpl.new({ kind = { type = "bool_value", value = input } })
		elseif typeof(input) == "table" then
			local isArray = true
			local count = 0
			for _ in input do
				count += 1
				if count > #input then
					isArray = false
					break
				end
			end

			isArray = count == #input

			if isArray then
				return _ValueImpl.new({ kind = { type = "list_value", value = messages.ListValue.jsonDecode(input) } })
			else
				return _ValueImpl.new({ kind = { type = "struct_value", value = messages.Struct.jsonDecode(input) } })
			end
		else
			error(`Unknown input type: {typeof(input)}`)
		end
	end

	_ValueImpl.descriptor = {
		name = "Value",
		fullName = "google.protobuf.Value",
	}

	messages.Value = _ValueImpl :: any -- Luau: Not sure why this intersection fails.

	typeRegistry.default:register(messages.Value)
end

do
	local _ListValueImpl = {}
	_ListValueImpl.__index = _ListValueImpl

	function _ListValueImpl.new(data: _ListValuePartialFields?): ListValue
		return setmetatable({
			values = if data == nil or data.values == nil then {} else data.values,
		}, _ListValueImpl :: _ListValueImpl)
	end

	function _ListValueImpl.encode(self: ListValue): buffer
		local output = buffer.create(0)
		local cursor = 0

		if self.values ~= nil and #self.values > 0 then
			for _, value in self.values do
				local encoded = value:encode()
				output, cursor = proto.writeTag(output, cursor, 1, proto.wireTypes.lengthDelimited)
				output, cursor = proto.writeBuffer(output, cursor, encoded, buffer.len(encoded))
			end
		end

		local shrunkBuffer = buffer.create(cursor)
		buffer.copy(shrunkBuffer, 0, output, 0, cursor)
		return shrunkBuffer
	end

	function _ListValueImpl.decode(input: buffer): ListValue
		local self = _ListValueImpl.new()
		local cursor = 0

		while cursor < buffer.len(input) do
			local field, wireType
			field, wireType, cursor = proto.readTag(input, cursor)

			if wireType == proto.wireTypes.varint then
				-- No fields

				local _
				_, cursor = proto.readVarInt(input, cursor)
			elseif wireType == proto.wireTypes.lengthDelimited then
				if field == 1 then
					local value
					value, cursor = proto.readBuffer(input, cursor)
					table.insert(self.values, messages.Value.decode(value))
					continue
				end

				local length
				length, cursor = proto.readVarInt(input, cursor)

				cursor += length
			elseif wireType == proto.wireTypes.i32 then
				-- No fields

				local _
				_, cursor = proto.readFixed32(input, cursor)
			elseif wireType == proto.wireTypes.i64 then
				-- No fields

				local _
				_, cursor = proto.readFixed64(input, cursor)
			else
				error("Unsupported wire type: " .. wireType)
			end
		end

		return self
	end

	function _ListValueImpl.jsonEncode(list: ListValue): { any }
		local serialized = {}

		for _, value in list.values do
			table.insert(serialized, messages.Value.jsonEncode(value))
		end

		return serialized
	end

	function _ListValueImpl.jsonDecode(anyValue: any): ListValue
		local input: { any } = anyValue

		local values = {}

		for _, value in input do
			table.insert(values, messages.Value.jsonDecode(value))
		end

		return _ListValueImpl.new({
			values = values,
		})
	end

	_ListValueImpl.descriptor = {
		name = "ListValue",
		fullName = "google.protobuf.ListValue",
	}

	messages.ListValue = _ListValueImpl :: any -- Luau: Not sure why this intersection fails.

	typeRegistry.default:register(messages.ListValue)
end

messages.NullValue = {
	fromNumber = function(value: number): NullValue?
		if value == 0 then
			return "NULL_VALUE"
		else
			return nil
		end
	end,

	toNumber = function(self: NullValue): number
		if self == "NULL_VALUE" then
			return 0
		else
			return self
		end
	end,

	fromName = function(name: string): NullValue?
		if name == "NULL_VALUE" then
			return "NULL_VALUE"
		else
			return nil
		end
	end,
}

return {
	Struct = messages.Struct,
	Value = messages.Value,
	ListValue = messages.ListValue,
	NullValue = messages.NullValue,
}
