local Foundation = script:FindFirstAncestor("Foundation")
local Packages = Foundation.Parent

local React = require(Packages.React)

local Icon = require(Foundation.Components.Icon)
local IconSize = require(Foundation.Enums.IconSize)
type IconSize = IconSize.IconSize

local useTokens = require(Foundation.Providers.Style.useTokens)
local withDefaults = require(Foundation.Utility.withDefaults)
local useRotation = require(Foundation.Utility.useRotation)
local Types = require(Foundation.Components.Types)
local withCommonProps = require(Foundation.Utility.withCommonProps)

type Props = {
	size: IconSize?,
} & Types.CommonProps

local defaultProps = {
	size = IconSize.Large,
}

local function Loading(loadingProps: Props, ref: React.Ref<GuiObject>?)
	local props = withDefaults(loadingProps, defaultProps)
	local rotation = useRotation()
	local tokens = useTokens()

	return React.createElement(
		Icon,
		withCommonProps(props, {
			name = "icons/graphic/loadingspinner",
			size = props.size,
			style = tokens.DarkMode.Content.Emphasis,
			Rotation = rotation,
			ref = ref,
		})
	)
end

return React.memo(React.forwardRef(Loading))
