--!strict
--!nolint LocalUnused
--!nolint ImportUnused
--# selene: allow(empty_if, if_same_then_else, manual_table_clone, unused_variable)
-- This file was @autogenerated by protoc-gen-luau
local proto = require(script.Parent.Parent.Parent.proto)
local typeRegistry = require(script.Parent.Parent.Parent.proto.typeRegistry)

type _Messages = {
	Timestamp: _TimestampMessage,
}
local messages: _Messages = {} :: _Messages

type _TimestampImpl = {
	__index: _TimestampImpl,
	new: (fields: _TimestampPartialFields?) -> Timestamp,
	encode: (self: Timestamp) -> buffer,
	decode: (input: buffer) -> Timestamp,
	jsonEncode: (self: Timestamp) -> string,
	jsonDecode: (input: string) -> Timestamp,
	descriptor: proto.Descriptor,
}

type _TimestampFields = {
	seconds: number,
	nanos: number,
}

type _TimestampPartialFields = {
	seconds: number?,
	nanos: number?,
}

export type Timestamp = typeof(setmetatable({} :: _TimestampFields, {} :: _TimestampImpl))
type _TimestampMessage = proto.Message<Timestamp, _TimestampPartialFields> & proto.CustomJson<Timestamp, string>

do
	local _TimestampImpl = {}
	_TimestampImpl.__index = _TimestampImpl

	function _TimestampImpl.new(data: _TimestampPartialFields?): Timestamp
		return setmetatable({
			seconds = if data == nil or data.seconds == nil then 0 else data.seconds,
			nanos = if data == nil or data.nanos == nil then 0 else data.nanos,
		}, _TimestampImpl :: _TimestampImpl)
	end

	function _TimestampImpl.encode(self: Timestamp): buffer
		local output = buffer.create(0)
		local cursor = 0

		if self.seconds ~= nil and self.seconds ~= 0 then
			output, cursor = proto.writeTag(output, cursor, 1, proto.wireTypes.varint)
			output, cursor = proto.writeVarInt(output, cursor, self.seconds)
		end

		if self.nanos ~= nil and self.nanos ~= 0 then
			output, cursor = proto.writeTag(output, cursor, 2, proto.wireTypes.varint)
			output, cursor = proto.writeVarInt(output, cursor, self.nanos)
		end

		local shrunkBuffer = buffer.create(cursor)
		buffer.copy(shrunkBuffer, 0, output, 0, cursor)
		return shrunkBuffer
	end

	function _TimestampImpl.decode(input: buffer): Timestamp
		local self = _TimestampImpl.new()
		local cursor = 0

		while cursor < buffer.len(input) do
			local field, wireType
			field, wireType, cursor = proto.readTag(input, cursor)

			if wireType == proto.wireTypes.varint then
				if field == 1 then
					local value
					value, cursor = proto.readVarIntI64(input, cursor)
					self.seconds = value
					continue
				elseif field == 2 then
					local value
					value, cursor = proto.readVarIntI32(input, cursor)
					self.nanos = value
					continue
				end

				local _
				_, cursor = proto.readVarInt(input, cursor)
			elseif wireType == proto.wireTypes.lengthDelimited then
				-- No fields

				local length
				length, cursor = proto.readVarInt(input, cursor)

				cursor += length
			elseif wireType == proto.wireTypes.i32 then
				-- No fields

				local _
				_, cursor = proto.readFixed32(input, cursor)
			elseif wireType == proto.wireTypes.i64 then
				-- No fields

				local _
				_, cursor = proto.readFixed64(input, cursor)
			else
				error("Unsupported wire type: " .. wireType)
			end
		end

		return self
	end

	local function serializeFractionalNanos(nanos: number): string
		if nanos % 1e6 == 0 then
			return string.format(".%03d", nanos)
		elseif nanos % 1e3 == 0 then
			return string.format(".%06d", nanos)
		else
			return string.format(".%09d", nanos)
		end
	end

	local function deserializeFractionalNanos(nanosText: string): number
		local nanos = assert(tonumber(nanosText), "Invalid nanos string received, couldn't turn into a number")
		for digit = #nanosText + 1, 9 do
			nanos += 10 ^ (digit - 1)
		end

		return nanos
	end

	function _TimestampImpl.jsonEncode(timestamp: Timestamp): string
		if timestamp.seconds > 253402300799 then
			error("Invalid timestamp provided: years after 9999 are not supported")
		end

		if timestamp.seconds < -62135596800 then
			error("Invalid timestamp provided: years before 0001 are not supported")
		end

		local dateInfo = os.date("!*t", timestamp.seconds or 0)
		if dateInfo == nil then
			error("Invalid timestamp provided: exceeded supported timestamp range on this platform")
		end

		return string.format(
			"%04d-%02d-%02dT%02d:%02d:%02d%sZ",
			dateInfo.year,
			dateInfo.month,
			dateInfo.day,
			dateInfo.hour,
			dateInfo.min,
			dateInfo.sec,
			if timestamp.nanos == 0 then "" else serializeFractionalNanos(timestamp.nanos)
		)
	end

	function _TimestampImpl.jsonDecode(anyValue: any): Timestamp
		local text: string = anyValue

		local year, month, day, hour, min, sec, nanosWithDot =
			string.match(text, "^([0-9]+)-([0-9]+)-([0-9]+)T([0-9]+):([0-9]+):([0-9]+)(.*)Z$")

		if
			year == nil
			or month == nil
			or day == nil
			or hour == nil
			or min == nil
			or sec == nil
			or nanosWithDot == nil
		then
			error("Invalid timestamp provided")
		end

		local nanos = 0
		if #nanosWithDot ~= 0 then
			local nanosText = string.match(nanosWithDot, "^%.([0-9]+)$")
			if nanosText == nil then
				error("Invalid nanoseconds provided in timestamp: `" .. nanosWithDot .. "`")
			end

			nanos = deserializeFractionalNanos(nanosText)
		end

		local totalSeconds = os.time({
			year = assert(tonumber(year), "Invalid formatted year"),
			month = assert(tonumber(month), "Invalid formatted month"),
			day = assert(tonumber(day), "Invalid formatted day"),
			hour = assert(tonumber(hour), "Invalid formatted hour"),
			min = assert(tonumber(min), "Invalid formatted min"),
			sec = assert(tonumber(sec), "Invalid formatted sec"),
		})

		return _TimestampImpl.new({
			seconds = totalSeconds,
			nanos = nanos,
		})
	end

	_TimestampImpl.descriptor = {
		name = "Timestamp",
		fullName = "google.protobuf.Timestamp",
	}

	messages.Timestamp = _TimestampImpl :: any -- Luau: Not sure why this intersection fails.

	typeRegistry.default:register(messages.Timestamp)
end

return {
	Timestamp = messages.Timestamp,
}
